/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.convert;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import org.h2gis.api.DeterministicScalarFunction;

public class ST_GoogleMapLink
extends DeterministicScalarFunction {
    public ST_GoogleMapLink() {
        this.addProperty("remarks", "Generate a Google Map link URL based on the center of the bounding box of the input geometry.\nOptional arguments :\n (1) specify the layer type  m (normal  map) , k (satellite), h (hybrid), p (terrain).\n (2) set a zoom level between 1 and 19.\n Default values are m and 19.");
    }

    public String getJavaStaticMethod() {
        return "generateGMLink";
    }

    public static String generateGMLink(Geometry geom) {
        return ST_GoogleMapLink.generateGMLink(geom, "m", 19);
    }

    public static String generateGMLink(Geometry geom, String layerType) {
        return ST_GoogleMapLink.generateGMLink(geom, layerType, 19);
    }

    public static String generateGMLink(Geometry geom, String layerType, int zoom) {
        if (geom == null) {
            return null;
        }
        try {
            LayerType layer = LayerType.valueOf(layerType.toLowerCase());
            Coordinate centre = geom.getEnvelopeInternal().centre();
            StringBuilder sb = new StringBuilder("https://maps.google.com/maps?ll=");
            sb.append(centre.y);
            sb.append(",");
            sb.append(centre.x);
            sb.append("&z=");
            sb.append(zoom);
            sb.append("&t=");
            sb.append(layer.name());
            return sb.toString();
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Layer type supported are m (normal  map) , k (satellite), h (hybrid), p (terrain)", ex);
        }
    }

    public static enum LayerType {
        m,
        k,
        h,
        p;

    }
}

