/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.create;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.h2.tools.SimpleResultSet;
import org.h2.tools.SimpleRowSource;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.SFSUtilities;
import org.h2gis.utilities.TableLocation;

public class GridRowSet
implements SimpleRowSource {
    private static final GeometryFactory GF = new GeometryFactory();
    private static int cellI = 0;
    private static int cellJ = 0;
    private int maxI;
    private int maxJ;
    private double deltaX;
    private double deltaY;
    private double minX;
    private double minY;
    private int id = 0;
    private final Connection connection;
    private boolean firstRow = true;
    private Envelope envelope;
    private boolean isTable;
    private String tableName;
    private boolean isCenterCell = false;

    public GridRowSet(Connection connection, double deltaX, double deltaY, String tableName) {
        this.connection = connection;
        this.deltaX = deltaX;
        this.deltaY = deltaY;
        this.tableName = tableName;
        this.isTable = true;
    }

    public GridRowSet(Connection connection, double deltaX, double deltaY, Envelope envelope) {
        this.connection = connection;
        this.deltaX = deltaX;
        this.deltaY = deltaY;
        this.envelope = envelope;
        this.isTable = false;
    }

    public Object[] readRow() throws SQLException {
        if (this.firstRow) {
            this.reset();
        }
        if (cellI == this.maxI) {
            ++cellJ;
            cellI = 0;
        }
        if (cellJ >= this.maxJ) {
            cellJ = 0;
            return null;
        }
        if (this.isCenterCell) {
            return new Object[]{this.getCellPoint(), this.id++, cellI, cellJ + 1};
        }
        return new Object[]{this.getCellPolygon(), this.id++, cellI, cellJ + 1};
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws SQLException {
        cellI = 0;
        cellJ = 0;
        this.firstRow = false;
        if (this.isTable) {
            Statement statement = this.connection.createStatement();
            try (ResultSet rs = statement.executeQuery("select ST_Extent(" + GridRowSet.getFirstGeometryField(this.tableName, this.connection) + ")  from " + this.tableName);){
                rs.next();
                Geometry geomExtend = (Geometry)rs.getObject(1);
                if (geomExtend == null) {
                    throw new SQLException("The envelope cannot be null.");
                }
                this.envelope = geomExtend.getEnvelopeInternal();
                this.initParameters();
            }
        } else {
            if (this.envelope == null) {
                throw new SQLException("The input geometry used to compute the grid cannot be null.");
            }
            this.initParameters();
        }
    }

    private Polygon getCellPolygon() {
        Coordinate[] summits = new Coordinate[5];
        double x1 = this.minX + (double)cellI * this.deltaX;
        double y1 = this.minY + (double)cellJ * this.deltaY;
        double x2 = this.minX + (double)(cellI + 1) * this.deltaX;
        double y2 = this.minY + (double)(cellJ + 1) * this.deltaY;
        summits[0] = new Coordinate(x1, y1);
        summits[1] = new Coordinate(x2, y1);
        summits[2] = new Coordinate(x2, y2);
        summits[3] = new Coordinate(x1, y2);
        summits[4] = new Coordinate(x1, y1);
        LinearRing g = GF.createLinearRing(summits);
        Polygon gg = GF.createPolygon(g, null);
        ++cellI;
        return gg;
    }

    private Point getCellPoint() {
        double x1 = this.minX + (double)cellI * this.deltaX + this.deltaX / 2.0;
        double y1 = this.minY + (double)cellJ * this.deltaY + this.deltaY / 2.0;
        ++cellI;
        return GF.createPoint(new Coordinate(x1, y1));
    }

    public boolean isCenterCell() {
        return this.isCenterCell;
    }

    public void setCenterCell(boolean isCenterCell) {
        this.isCenterCell = isCenterCell;
    }

    private static String getFirstGeometryField(String tableName, Connection connection) throws SQLException {
        List geomFields = SFSUtilities.getGeometryFields((Connection)connection, (TableLocation)TableLocation.parse((String)tableName, (Boolean)JDBCUtilities.isH2DataBase((DatabaseMetaData)connection.getMetaData())));
        if (!geomFields.isEmpty()) {
            return (String)geomFields.get(0);
        }
        throw new SQLException("The table " + tableName + " does not contain a geometry field");
    }

    private void initParameters() {
        this.minX = this.envelope.getMinX();
        this.minY = this.envelope.getMinY();
        double cellWidth = this.envelope.getWidth();
        double cellHeight = this.envelope.getHeight();
        this.maxI = (int)Math.ceil(cellWidth / this.deltaX);
        this.maxJ = (int)Math.ceil(cellHeight / this.deltaY);
    }

    public ResultSet getResultSet() throws SQLException {
        SimpleResultSet srs = new SimpleResultSet((SimpleRowSource)this);
        srs.addColumn("THE_GEOM", 2000, "GEOMETRY", 0, 0);
        srs.addColumn("ID", 4, 10, 0);
        srs.addColumn("ID_COL", 4, 10, 0);
        srs.addColumn("ID_ROW", 4, 10, 0);
        return srs;
    }
}

