/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.create;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.functions.spatial.volume.GeometryExtrude;

public class ST_Extrude
extends DeterministicScalarFunction {
    public ST_Extrude() {
        this.addProperty("remarks", "ST_Extrude takes a LINESTRING or POLYGON as input\n and extends it to a 3D representation, returning a geometry collection\n containing floor, ceiling and wall geometries.\nNote: the NaN z value of the input geometry are replaced by a zero.");
    }

    public String getJavaStaticMethod() {
        return "extrudeGeometry";
    }

    public static GeometryCollection extrudeGeometry(Geometry geometry, double height) throws SQLException {
        if (geometry == null) {
            return null;
        }
        if (geometry instanceof Polygon) {
            return GeometryExtrude.extrudePolygonAsGeometry((Polygon)geometry, height);
        }
        if (geometry instanceof LineString) {
            return GeometryExtrude.extrudeLineStringAsGeometry((LineString)geometry, height);
        }
        throw new SQLException("Only LINESTRING and POLYGON inputs are accepted.");
    }

    public static Geometry extrudeGeometry(Geometry geometry, double height, int flag) throws SQLException {
        if (geometry == null) {
            return null;
        }
        if (geometry instanceof Polygon) {
            if (flag == 1) {
                return GeometryExtrude.extractWalls((Polygon)geometry, height);
            }
            if (flag == 2) {
                return GeometryExtrude.extractRoof((Polygon)geometry, height);
            }
            throw new SQLException("Incorrect flag value. Please set 1 to extract walls or 2 to extract roof.");
        }
        if (geometry instanceof LineString) {
            if (flag == 1) {
                return GeometryExtrude.extractWalls((LineString)geometry, height);
            }
            if (flag == 2) {
                return GeometryExtrude.extractRoof((LineString)geometry, height);
            }
            throw new SQLException("Incorrect flag value. Please set 1 to extract walls or 2 to extract roof.");
        }
        throw new SQLException("Only LINESTRING and POLYGON inputs are accepted.");
    }
}

