/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.earth;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.Date;

public class SunCalc {
    private static final double rad = Math.PI / 180;
    private static final double dayMs = 8.64E7;
    private static final double J1970 = 2440588.0;
    private static final double J2000 = 2451545.0;
    private static final double M0 = 6.240059966692059;
    private static final double M1 = 0.017201969994578018;
    private static final double J0 = 9.0E-4;
    private static final double J1 = 0.0053;
    private static final double J2 = -0.0069;
    private static final double C1 = 0.033419564517187424;
    private static final double C2 = 3.4906585039886593E-4;
    private static final double C3 = 5.235987755982989E-6;
    private static final double P = 1.796593062783907;
    private static final double e = 0.40909994067971484;
    private static final double th0 = 4.889714432387314;
    private static final double th1 = 6.3003876824396166;

    private SunCalc() {
    }

    private static double dateToJulianDate(Date date) {
        return (double)date.getTime() / 8.64E7 - 0.5 + 2440588.0;
    }

    private static Date julianDateToDate(double j) {
        return new Date(Math.round((j + 0.5 - 2440588.0) * 8.64E7));
    }

    private static long getJulianCycle(double J, double lw) {
        return Math.round(J - 2451545.0 - 9.0E-4 - lw / (Math.PI * 2));
    }

    private static double getSolarMeanAnomaly(double Js) {
        return 6.240059966692059 + 0.017201969994578018 * (Js - 2451545.0);
    }

    private static double getEquationOfCenter(double M) {
        return 0.033419564517187424 * Math.sin(M) + 3.4906585039886593E-4 * Math.sin(2.0 * M) + 5.235987755982989E-6 * Math.sin(3.0 * M);
    }

    private static double getEclipticLongitude(double M, double C) {
        return M + 1.796593062783907 + C + Math.PI;
    }

    private static double getSunDeclination(double Ls) {
        return Math.asin(Math.sin(Ls) * Math.sin(0.40909994067971484));
    }

    private static double getApproxTransit(double Ht, double lw, double n) {
        return 2451545.0009 + (Ht + lw) / (Math.PI * 2) + n;
    }

    private static double getSolarTransit(double Js, double M, double Ls) {
        return Js + 0.0053 * Math.sin(M) + -0.0069 * Math.sin(2.0 * Ls);
    }

    private static double getHourAngle(double h, double phi, double d) {
        return Math.acos((Math.sin(h) - Math.sin(phi) * Math.sin(d)) / (Math.cos(phi) * Math.cos(d)));
    }

    private static double getRightAscension(double Ls) {
        return Math.atan2(Math.sin(Ls) * Math.cos(0.40909994067971484), Math.cos(Ls));
    }

    private static double getSiderealTime(double J, double lw) {
        return 4.889714432387314 + 6.3003876824396166 * (J - 2451545.0) - lw;
    }

    private static double getAzimuth(double H, double phi, double d) {
        return Math.atan2(Math.sin(H), Math.cos(H) * Math.sin(phi) - Math.tan(d) * Math.cos(phi)) + Math.PI;
    }

    private static double getAltitude(double H, double phi, double d) {
        return Math.asin(Math.sin(phi) * Math.sin(d) + Math.cos(phi) * Math.cos(d) * Math.cos(H));
    }

    public static Coordinate getPosition(Date date, double lat, double lng) {
        if (SunCalc.isGeographic(lat, lng)) {
            double lw = Math.PI / 180 * -lng;
            double phi = Math.PI / 180 * lat;
            double J = SunCalc.dateToJulianDate(date);
            double M = SunCalc.getSolarMeanAnomaly(J);
            double C = SunCalc.getEquationOfCenter(M);
            double Ls = SunCalc.getEclipticLongitude(M, C);
            double d = SunCalc.getSunDeclination(Ls);
            double a = SunCalc.getRightAscension(Ls);
            double th = SunCalc.getSiderealTime(J, lw);
            double H = th - a;
            return new Coordinate(SunCalc.getAzimuth(H, phi, d), SunCalc.getAltitude(H, phi, d));
        }
        throw new IllegalArgumentException("The coordinate of the point must in latitude and longitude.");
    }

    public static boolean isGeographic(double latitude, double longitude) {
        return latitude > -90.0 && latitude < 90.0 && longitude > -180.0 && longitude < 180.0;
    }
}

