/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.properties;

import com.vividsolutions.jts.geom.Geometry;
import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;

public class ST_GeometryN
extends DeterministicScalarFunction {
    private static final String OUT_OF_BOUNDS_ERR_MESSAGE = "Geometry index out of range. Must be between 1 and ST_NumGeometries.";

    public ST_GeometryN() {
        this.addProperty("remarks", "Returns Geometry number n from a GeometryCollection. Use ST_NumGeometries to retrieve the total number of Geometries.");
    }

    public String getJavaStaticMethod() {
        return "getGeometryN";
    }

    public static Geometry getGeometryN(Geometry geometry, Integer n) throws SQLException {
        if (geometry == null) {
            return null;
        }
        if (n >= 1 && n <= geometry.getNumGeometries()) {
            return geometry.getGeometryN(n - 1);
        }
        throw new SQLException(OUT_OF_BOUNDS_ERR_MESSAGE);
    }
}

