/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.type;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.h2gis.api.DeterministicScalarFunction;

public class GeometryTypeFromConstraint
extends DeterministicScalarFunction {
    private static final Pattern TYPE_CODE_PATTERN = Pattern.compile("ST_GeometryTypeCode\\s*\\(\\s*((([\"`][^\"`]+[\"`])|(\\w+)))\\s*\\)\\s*=\\s*(\\d)+", 2);
    private static final int CODE_GROUP_ID = 5;

    public GeometryTypeFromConstraint() {
        this.addProperty("remarks", "Convert H2 constraint string into a OGC geometry type index.");
        this.addProperty("name", "_GeometryTypeFromConstraint");
    }

    public String getJavaStaticMethod() {
        return "geometryTypeFromConstraint";
    }

    public static int geometryTypeFromConstraint(String constraint, int numericPrecision) {
        if (constraint.isEmpty() && numericPrecision > 3000) {
            return 0;
        }
        if (numericPrecision <= 3000) {
            return numericPrecision;
        }
        Matcher matcher = TYPE_CODE_PATTERN.matcher(constraint);
        if (matcher.find()) {
            return Integer.valueOf(matcher.group(5));
        }
        return 0;
    }
}

