/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.network.functions;

import com.vividsolutions.jts.geom.Geometry;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.h2.tools.SimpleResultSet;
import org.h2gis.api.ScalarFunction;
import org.h2gis.network.functions.GraphFunction;
import org.h2gis.utilities.SFSUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.TableUtilities;
import org.javanetworkanalyzer.alg.Dijkstra;
import org.javanetworkanalyzer.data.VDijkstra;
import org.javanetworkanalyzer.model.Edge;
import org.javanetworkanalyzer.model.KeyedGraph;
import org.jgrapht.Graph;

public class ST_ShortestPath
extends GraphFunction
implements ScalarFunction {
    private int globalID = 1;
    public static final String NO_GEOM_FIELD_ERROR = "The input table must contain a geometry field.";
    public static final String REMARKS = "`ST_ShortestPath` calculates the shortest path(s) between vertices in a graph.\nPossible signatures:\n* `ST_ShortestPath('input_edges', 'o[ - eo]', s, d)`  - One-to-One\n* `ST_ShortestPath('input_edges', 'o[ - eo]', 'w', s, d)`  - One-to-One weighted\n\nwhere\n* `input_edges` = Edges table produced by `ST_Graph` from table `input`\n* `o` = Global orientation (directed, reversed or undirected)\n* `eo` = Edge orientation (1 = directed, -1 = reversed, 0 = undirected). Required\n  if global orientation is directed or reversed.\n* `w` = Name of column containing edge weights as doubles\n* `s` = Source vertex id\n* `d` = Destination vertex id\n";

    public ST_ShortestPath() {
        this.addProperty("remarks", REMARKS);
    }

    public String getJavaStaticMethod() {
        return "getShortestPath";
    }

    public static ResultSet getShortestPath(Connection connection, String inputTable, String orientation, int source, int destination) throws SQLException {
        return ST_ShortestPath.getShortestPath(connection, inputTable, orientation, null, source, destination);
    }

    public static ResultSet getShortestPath(Connection connection, String inputTable, String orientation, String weight, int source, int destination) throws SQLException {
        return ST_ShortestPath.oneToOne(connection, inputTable, orientation, weight, source, destination);
    }

    private static ResultSet oneToOne(Connection connection, String inputTable, String orientation, String weight, int source, int destination) throws SQLException {
        TableLocation tableName = TableUtilities.parseInputTable((Connection)connection, (String)inputTable);
        String firstGeometryField = ST_ShortestPath.getFirstGeometryField(connection, tableName);
        boolean containsGeomField = firstGeometryField != null;
        SimpleResultSet output = ST_ShortestPath.prepareResultSet(containsGeomField);
        if (TableUtilities.isColumnListConnection((Connection)connection)) {
            return output;
        }
        KeyedGraph graph = ST_ShortestPath.prepareGraph(connection, inputTable, orientation, weight, VDijkstra.class, Edge.class);
        Dijkstra dijkstra = new Dijkstra((Graph)graph);
        VDijkstra vDestination = (VDijkstra)graph.getVertex(destination);
        double distance = dijkstra.oneToOne((VDijkstra)graph.getVertex(source), vDestination);
        if (distance != Double.POSITIVE_INFINITY) {
            ST_ShortestPath f = new ST_ShortestPath();
            if (containsGeomField) {
                Map<Integer, Geometry> edgeGeometryMap = ST_ShortestPath.getEdgeGeometryMap(connection, tableName, firstGeometryField);
                f.addPredEdges((KeyedGraph<VDijkstra, Edge>)graph, vDestination, output, edgeGeometryMap, 1);
            } else {
                f.addPredEdges((KeyedGraph<VDijkstra, Edge>)graph, vDestination, output, 1);
            }
        }
        return output;
    }

    private void addPredEdges(KeyedGraph<VDijkstra, Edge> graph, VDijkstra dest, SimpleResultSet output, Map<Integer, Geometry> edgeGeomMap, int localID) throws SQLException {
        Set predEdges = dest.getPredecessorEdges();
        if (predEdges.isEmpty()) {
            ++this.globalID;
        }
        for (Edge e : predEdges) {
            VDijkstra edgeSource = (VDijkstra)graph.getEdgeSource((Object)e);
            VDijkstra edgeDestination = (VDijkstra)graph.getEdgeTarget((Object)e);
            Geometry geometry = edgeGeomMap.get(Math.abs(e.getID()));
            if (edgeDestination.equals(dest)) {
                output.addRow(new Object[]{geometry, e.getID(), this.globalID, localID, edgeSource.getID(), edgeDestination.getID(), graph.getEdgeWeight((Object)e)});
                this.addPredEdges(graph, edgeSource, output, edgeGeomMap, localID + 1);
                continue;
            }
            output.addRow(new Object[]{geometry, e.getID(), this.globalID, localID, edgeDestination.getID(), edgeSource.getID(), graph.getEdgeWeight((Object)e)});
            this.addPredEdges(graph, edgeDestination, output, edgeGeomMap, localID + 1);
        }
    }

    private void addPredEdges(KeyedGraph<VDijkstra, Edge> graph, VDijkstra dest, SimpleResultSet output, int localID) throws SQLException {
        Set predEdges = dest.getPredecessorEdges();
        if (predEdges.isEmpty()) {
            ++this.globalID;
        }
        for (Edge e : predEdges) {
            VDijkstra edgeSource = (VDijkstra)graph.getEdgeSource((Object)e);
            VDijkstra edgeDestination = (VDijkstra)graph.getEdgeTarget((Object)e);
            if (edgeDestination.equals(dest)) {
                output.addRow(new Object[]{e.getID(), this.globalID, localID, edgeSource.getID(), edgeDestination.getID(), graph.getEdgeWeight((Object)e)});
                this.addPredEdges(graph, edgeSource, output, localID + 1);
                continue;
            }
            output.addRow(new Object[]{e.getID(), this.globalID, localID, edgeDestination.getID(), edgeSource.getID(), graph.getEdgeWeight((Object)e)});
            this.addPredEdges(graph, edgeDestination, output, localID + 1);
        }
    }

    protected static String getFirstGeometryField(Connection connection, TableLocation tableName) throws SQLException {
        List geometryFields = SFSUtilities.getGeometryFields((Connection)connection, (TableLocation)tableName);
        if (geometryFields.isEmpty()) {
            return null;
        }
        return (String)geometryFields.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map<Integer, Geometry> getEdgeGeometryMap(Connection connection, TableLocation tableName, String firstGeometryField) throws SQLException {
        if (firstGeometryField == null) {
            return null;
        }
        try (Statement st = connection.createStatement();){
            HashMap<Integer, Geometry> hashMap;
            ResultSet resultSet = st.executeQuery("SELECT EDGE_ID, " + firstGeometryField + " FROM " + tableName);
            try {
                HashMap<Integer, Geometry> edgeGeomMap = new HashMap<Integer, Geometry>();
                while (resultSet.next()) {
                    int edgeID = resultSet.getInt(1);
                    Geometry geom = (Geometry)resultSet.getObject(2);
                    edgeGeomMap.put(edgeID, geom);
                }
                hashMap = edgeGeomMap;
            }
            catch (Throwable throwable) {
                resultSet.close();
                throw throwable;
            }
            resultSet.close();
            return hashMap;
        }
    }

    private static SimpleResultSet prepareResultSet(boolean includeGeomColumn) {
        SimpleResultSet output = new SimpleResultSet();
        if (includeGeomColumn) {
            output.addColumn("THE_GEOM", 2000, "GEOMETRY", 0, 0);
        }
        output.addColumn("EDGE_ID", 4, 10, 0);
        output.addColumn("PATH_ID", 4, 10, 0);
        output.addColumn("PATH_EDGE_ID", 4, 10, 0);
        output.addColumn("SOURCE", 4, 10, 0);
        output.addColumn("DESTINATION", 4, 10, 0);
        output.addColumn("WEIGHT", 8, 10, 0);
        return output;
    }
}

