/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.osgi;

import java.io.File;
import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.h2.Driver;
import org.h2.util.OsgiDataSourceFactory;
import org.h2gis.functions.factory.H2GISFunctions;

public class H2GISOsgiDBFactory {
    public static final String H2_PARAMETERS = ";DB_CLOSE_ON_EXIT=FALSE";

    private H2GISOsgiDBFactory() {
    }

    public static Connection openSpatialDataBase(String dbName) throws SQLException, ClassNotFoundException {
        String dbFilePath = H2GISOsgiDBFactory.getDataBasePath(dbName);
        String databasePath = "jdbc:h2:" + dbFilePath + H2_PARAMETERS;
        Driver.load();
        return DriverManager.getConnection(databasePath, "sa", "sa");
    }

    public static Connection createSpatialDataBase(String dbName) throws SQLException, ClassNotFoundException {
        return H2GISOsgiDBFactory.createSpatialDataBase(dbName, true);
    }

    private static String getDataBasePath(String dbName) {
        if (dbName.startsWith("file://")) {
            return new File(URI.create(dbName)).getAbsolutePath();
        }
        return new File("target/test-resources/dbH2" + dbName).getAbsolutePath();
    }

    public static DataSource createDataSource(String dbName, boolean initSpatial) throws SQLException {
        return H2GISOsgiDBFactory.createDataSource(dbName, initSpatial, H2_PARAMETERS);
    }

    public static DataSource createDataSource(Properties properties) throws SQLException {
        return H2GISOsgiDBFactory.createDataSource(properties, true);
    }

    public static DataSource createDataSource(Properties properties, boolean initSpatial) throws SQLException {
        Driver driver = Driver.load();
        OsgiDataSourceFactory dataSourceFactory = new OsgiDataSourceFactory(driver);
        DataSource dataSource = dataSourceFactory.createDataSource(properties);
        if (initSpatial) {
            try (Connection connection = dataSource.getConnection();){
                H2GISFunctions.load((Connection)connection);
            }
        }
        return dataSource;
    }

    public static DataSource createDataSource(String dbName, boolean initSpatial, String h2Parameters) throws SQLException {
        Driver driver = Driver.load();
        OsgiDataSourceFactory dataSourceFactory = new OsgiDataSourceFactory(driver);
        Properties properties = new Properties();
        String databasePath = H2GISOsgiDBFactory.initDBFile(dbName, h2Parameters);
        properties.setProperty("url", databasePath);
        properties.setProperty("user", "sa");
        properties.setProperty("password", "sa");
        DataSource dataSource = dataSourceFactory.createDataSource(properties);
        if (initSpatial) {
            try (Connection connection = dataSource.getConnection();){
                H2GISFunctions.load((Connection)connection);
            }
        }
        return dataSource;
    }

    private static String initDBFile(String dbName, String h2_PARAMETERS) {
        String dbFilePath = H2GISOsgiDBFactory.getDataBasePath(dbName);
        File dbFile = new File(dbFilePath + ".mv.db");
        String databasePath = "jdbc:h2:" + dbFilePath + h2_PARAMETERS;
        if (dbFile.exists()) {
            dbFile.delete();
        }
        if ((dbFile = new File(dbFilePath + ".mv.db")).exists()) {
            dbFile.delete();
        }
        return databasePath;
    }

    public static Connection createSpatialDataBase(String dbName, boolean initSpatial, String h2Parameters) throws SQLException, ClassNotFoundException {
        String databasePath = H2GISOsgiDBFactory.initDBFile(dbName, h2Parameters);
        Driver.load();
        Connection connection = DriverManager.getConnection(databasePath, "sa", "sa");
        if (initSpatial) {
            H2GISFunctions.load((Connection)connection);
        }
        return connection;
    }

    public static Connection createSpatialDataBase(String dbName, boolean initSpatial) throws SQLException, ClassNotFoundException {
        return H2GISOsgiDBFactory.createSpatialDataBase(dbName, initSpatial, H2_PARAMETERS);
    }
}

