/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.utilities.jts_utils;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.geom.Triangle;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import com.vividsolutions.jts.math.Vector2D;
import com.vividsolutions.jts.operation.polygonize.Polygonizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.h2gis.utilities.jts_utils.CoordinateSequenceDimensionFilter;

public class Voronoi {
    private Envelope envelope;
    private Geometry inputTriangles;
    private List<EnvelopeWithIndex> triVertex;
    private double epsilon = 1.0E-12;
    private boolean hasZ = false;
    private Triple[] triangleNeighbors = new Triple[0];
    private Triple[] triangleVertex;

    public Voronoi() {
    }

    public Voronoi(double epsilon) {
        this.epsilon = epsilon;
    }

    public void setEnvelope(Envelope envelope) throws TopologyException {
        this.envelope = envelope;
    }

    private int getOrAppendVertex(Coordinate newCoord, Quadtree ptQuad) {
        Envelope queryEnv = new Envelope(newCoord);
        queryEnv.expandBy(this.epsilon);
        QuadTreeVisitor visitor = new QuadTreeVisitor(this.epsilon, newCoord);
        try {
            ptQuad.query(queryEnv, (ItemVisitor)visitor);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (visitor.getNearest() != null) {
            return visitor.getNearest().index;
        }
        EnvelopeWithIndex ret = new EnvelopeWithIndex(this.triVertex.size(), newCoord);
        ptQuad.insert(queryEnv, (Object)ret);
        this.triVertex.add(ret);
        return ret.index;
    }

    public Triple[] generateTriangleNeighbors(Geometry geometry) throws TopologyException {
        this.inputTriangles = geometry;
        CoordinateSequenceDimensionFilter sequenceDimensionFilter = new CoordinateSequenceDimensionFilter();
        geometry.apply((CoordinateSequenceFilter)sequenceDimensionFilter);
        this.hasZ = sequenceDimensionFilter.getDimension() == 3;
        Quadtree ptQuad = new Quadtree();
        this.triangleVertex = new Triple[geometry.getNumGeometries()];
        this.triVertex = new ArrayList<EnvelopeWithIndex>(this.triangleVertex.length);
        for (int idgeom = 0; idgeom < this.triangleVertex.length; ++idgeom) {
            Geometry geomItem = geometry.getGeometryN(idgeom);
            if (geomItem instanceof Polygon) {
                Coordinate[] coords = geomItem.getCoordinates();
                if (coords.length != 4) {
                    throw new TopologyException("Voronoi method accept only triangles");
                }
                this.triangleVertex[idgeom] = new Triple(this.getOrAppendVertex(coords[0], ptQuad), this.getOrAppendVertex(coords[1], ptQuad), this.getOrAppendVertex(coords[2], ptQuad));
                for (int triVertexIndex : this.triangleVertex[idgeom].toArray()) {
                    this.triVertex.get(triVertexIndex).addSharingTriangle(idgeom);
                }
                continue;
            }
            throw new TopologyException("Voronoi method accept only polygons");
        }
        ptQuad = null;
        this.triangleNeighbors = new Triple[geometry.getNumGeometries()];
        for (int triId = 0; triId < this.triangleVertex.length; ++triId) {
            Triple triangleIndex = this.triangleVertex[triId];
            this.triangleNeighbors[triId] = new Triple(this.commonEdge(triId, this.triVertex.get(triangleIndex.getB()), this.triVertex.get(triangleIndex.getC())), this.commonEdge(triId, this.triVertex.get(triangleIndex.getA()), this.triVertex.get(triangleIndex.getC())), this.commonEdge(triId, this.triVertex.get(triangleIndex.getB()), this.triVertex.get(triangleIndex.getA())));
        }
        this.triVertex.clear();
        return this.triangleNeighbors;
    }

    private boolean triangleContainsPoint(Triangle tri, Coordinate pt) {
        return CGAlgorithms.isPointInRing((Coordinate)pt, (Coordinate[])new Coordinate[]{tri.p0, tri.p1, tri.p2, tri.p0});
    }

    private double fetchZ(Coordinate pt, int idGeom) {
        Triangle curTri = this.getTriangle(idGeom);
        while (!this.triangleContainsPoint(curTri, pt)) {
            int bestNeigh = -1;
            for (int idSeg = 0; idSeg < 3; ++idSeg) {
                LineSegment seg = this.getTriangleSegment(idGeom, idSeg);
                int ptPos = CGAlgorithms.orientationIndex((Coordinate)seg.p0, (Coordinate)seg.p1, (Coordinate)pt);
                if (CGAlgorithms.isCCW((Coordinate[])this.inputTriangles.getGeometryN(idGeom).getCoordinates())) {
                    ptPos = -ptPos;
                }
                if (ptPos == 1) {
                    bestNeigh = idSeg;
                    break;
                }
                if (ptPos != 0 || bestNeigh != -1) continue;
                bestNeigh = idSeg;
            }
            if (bestNeigh == -1) continue;
            if ((idGeom = this.triangleNeighbors[idGeom].get(bestNeigh)) >= 0) {
                curTri = this.getTriangle(idGeom);
                continue;
            }
            return Double.NaN;
        }
        return curTri.interpolateZ(pt);
    }

    private Coordinate getCircumcenter(int idgeom, Coordinate[] triangleCircumcenter) {
        Coordinate circumcenter = triangleCircumcenter[idgeom];
        if (circumcenter == null) {
            circumcenter = this.getTriangle(idgeom).circumcentre();
            if (this.hasZ) {
                circumcenter = new Coordinate(circumcenter.x, circumcenter.y, this.fetchZ(circumcenter, idgeom));
            }
            triangleCircumcenter[idgeom] = circumcenter;
        }
        return circumcenter;
    }

    private List<Integer> navigateTriangleNeigh(int idTri, int idVertex, int excludeTri, Coordinate[] triangleCircumcenter) {
        ArrayList<Integer> neigh = new ArrayList<Integer>();
        while (idTri != -1) {
            Triple triNeigh = this.triangleNeighbors[idTri];
            if (triNeigh.getA() != -1 && triNeigh.getA() != excludeTri && this.triangleVertex[triNeigh.getA()].contains(idVertex)) {
                excludeTri = idTri;
                idTri = triNeigh.getA();
            } else if (triNeigh.getB() != -1 && triNeigh.getB() != excludeTri && this.triangleVertex[triNeigh.getB()].contains(idVertex)) {
                excludeTri = idTri;
                idTri = triNeigh.getB();
            } else {
                if (triNeigh.getC() == -1 || triNeigh.getC() == excludeTri || !this.triangleVertex[triNeigh.getC()].contains(idVertex)) break;
                excludeTri = idTri;
                idTri = triNeigh.getC();
            }
            if (neigh.contains(idTri) || !this.doProcessTriangle(idTri, triangleCircumcenter)) {
                return neigh;
            }
            neigh.add(idTri);
        }
        return neigh;
    }

    private Polygon generateVoronoiPolygon(int idTri, int idVertex, Coordinate[] triangleCircumcenter) {
        GeometryFactory gf = this.inputTriangles.getFactory();
        List<Integer> triangleIndexPath = this.navigateTriangleNeigh(idTri, idVertex, -1, triangleCircumcenter);
        boolean loop = true;
        if (!triangleIndexPath.contains(idTri)) {
            List<Integer> otherSidePath;
            triangleIndexPath.add(0, idTri);
            boolean bl = loop = triangleIndexPath.size() > 2 && this.triangleNeighbors[triangleIndexPath.get(0)].contains(triangleIndexPath.get(triangleIndexPath.size() - 1));
            if (!loop && triangleIndexPath.size() > 2 && !(otherSidePath = this.navigateTriangleNeigh(idTri, idVertex, triangleIndexPath.get(1), triangleCircumcenter)).isEmpty()) {
                Collections.reverse(otherSidePath);
                triangleIndexPath.addAll(0, otherSidePath);
                loop = this.triangleNeighbors[triangleIndexPath.get(0)].contains(triangleIndexPath.get(triangleIndexPath.size() - 1));
            }
        }
        if (loop) {
            triangleIndexPath.add(triangleIndexPath.get(0));
            ArrayList<Coordinate> polygonVertex = new ArrayList<Coordinate>(triangleIndexPath.size());
            Coordinate lastCoord = null;
            for (Integer aTriangleIndexPath : triangleIndexPath) {
                Coordinate circumCenter = this.getCircumcenter(aTriangleIndexPath, triangleCircumcenter);
                if (lastCoord != null && !(lastCoord.distance(circumCenter) > this.epsilon)) continue;
                polygonVertex.add(circumCenter);
                lastCoord = circumCenter;
            }
            return gf.createPolygon(polygonVertex.toArray(new Coordinate[polygonVertex.size()]));
        }
        if (this.envelope == null) {
            return null;
        }
        return null;
    }

    private boolean isCCW(int idTri) {
        return CGAlgorithms.isCCW((Coordinate[])this.inputTriangles.getGeometryN(idTri).getCoordinates());
    }

    private Triangle getTriangle(int idTri) {
        Coordinate[] coordinates = this.inputTriangles.getGeometryN(idTri).getCoordinates();
        return new Triangle(coordinates[0], coordinates[1], coordinates[2]);
    }

    private LineSegment getTriangleSegment(int idTri, int idSegment) {
        int b;
        int a;
        Coordinate[] coordinates = this.inputTriangles.getGeometryN(idTri).getCoordinates();
        switch (idSegment) {
            case 0: {
                a = 1;
                b = 2;
                break;
            }
            case 1: {
                a = 2;
                b = 0;
                break;
            }
            default: {
                a = 0;
                b = 1;
            }
        }
        return new LineSegment(coordinates[a], coordinates[b]);
    }

    private LineString voronoiSide(int idgeom, int side, GeometryFactory geometryFactory, Coordinate circumcenter) {
        boolean triangleCCW = this.isCCW(idgeom);
        LineSegment sideGeom = this.getTriangleSegment(idgeom, side);
        Vector2D direction = new Vector2D(sideGeom.p0, sideGeom.p1);
        LineSegment voronoiLine = new LineSegment(circumcenter, new Coordinate((direction = direction.normalize().rotate(triangleCCW ? -1.5707963267948966 : 1.5707963267948966).multiply(this.envelope.maxExtent())).getX() + circumcenter.x, direction.getY() + circumcenter.y));
        Geometry lineString = voronoiLine.toGeometry(geometryFactory).intersection(geometryFactory.toGeometry(this.envelope));
        if (lineString instanceof LineString && lineString.getLength() > this.epsilon) {
            return (LineString)lineString;
        }
        return null;
    }

    private boolean doProcessTriangle(int idGeom, Coordinate[] triangleCircumcenter) {
        return this.envelope == null || this.envelope.contains(this.getCircumcenter(idGeom, triangleCircumcenter));
    }

    public GeometryCollection generateVoronoi(int outputDimension) throws TopologyException {
        GeometryFactory geometryFactory = this.inputTriangles.getFactory();
        if (this.triangleNeighbors == null || this.triangleNeighbors.length == 0) {
            return geometryFactory.createMultiLineString(new LineString[0]);
        }
        Coordinate[] triangleCircumcenter = new Coordinate[this.inputTriangles.getNumGeometries()];
        if (outputDimension == 2 && this.envelope == null) {
            ArrayList<Polygon> polygons = new ArrayList<Polygon>(triangleCircumcenter.length);
            HashSet<Integer> processedVertex = new HashSet<Integer>();
            for (int idgeom = 0; idgeom < triangleCircumcenter.length; ++idgeom) {
                Geometry geomItem = this.inputTriangles.getGeometryN(idgeom);
                if (geomItem instanceof Polygon) {
                    if (!this.doProcessTriangle(idgeom, triangleCircumcenter)) continue;
                    Triple neigh = this.triangleNeighbors[idgeom];
                    for (int sideNeigh = 0; sideNeigh < 3; ++sideNeigh) {
                        int neighIndex = neigh.get(sideNeigh);
                        for (int vertexSide = 0; vertexSide < 3; ++vertexSide) {
                            if (vertexSide == sideNeigh) continue;
                            int vertexIndex = this.triangleVertex[idgeom].get(vertexSide);
                            if (neighIndex == -1 || processedVertex.contains(vertexIndex)) continue;
                            Polygon result = this.generateVoronoiPolygon(idgeom, vertexIndex, triangleCircumcenter);
                            if (result != null) {
                                polygons.add(result);
                            }
                            processedVertex.add(vertexIndex);
                        }
                    }
                    continue;
                }
                throw new TopologyException("Voronoi method accept only polygons");
            }
            MultiPolygon result = geometryFactory.createMultiPolygon(polygons.toArray(new Polygon[polygons.size()]));
            if (this.envelope == null) {
                return result;
            }
            return (GeometryCollection)geometryFactory.toGeometry(this.envelope).intersection((Geometry)result);
        }
        if (outputDimension == 1 || this.envelope != null && outputDimension == 2) {
            ArrayList<LineString> lineStrings = new ArrayList<LineString>(triangleCircumcenter.length);
            ArrayList<LineString> voronoiBorderLines = new ArrayList<LineString>();
            for (int idgeom = 0; idgeom < triangleCircumcenter.length; ++idgeom) {
                Geometry geomItem = this.inputTriangles.getGeometryN(idgeom);
                if (geomItem instanceof Polygon) {
                    if (!this.doProcessTriangle(idgeom, triangleCircumcenter)) continue;
                    Triple neigh = this.triangleNeighbors[idgeom];
                    for (int side = 0; side < 3; ++side) {
                        LineString lineString;
                        int neighIndex = neigh.get(side);
                        if (neighIndex >= 0 && !this.doProcessTriangle(neighIndex, triangleCircumcenter)) {
                            neighIndex = -1;
                        }
                        if (neighIndex > idgeom) {
                            Coordinate[] coordinateArray = new Coordinate[]{this.getCircumcenter(idgeom, triangleCircumcenter), this.getCircumcenter(neighIndex, triangleCircumcenter)};
                            lineString = geometryFactory.createLineString(coordinateArray);
                            if (!(lineString.getLength() > this.epsilon)) continue;
                            lineStrings.add(lineString);
                            continue;
                        }
                        if (neighIndex != -1 || this.envelope == null || (lineString = this.voronoiSide(idgeom, side, geometryFactory, this.getCircumcenter(idgeom, triangleCircumcenter))) == null) continue;
                        voronoiBorderLines.add(lineString);
                    }
                    continue;
                }
                throw new TopologyException("Voronoi method accept only polygons");
            }
            if (this.envelope != null) {
                voronoiBorderLines.add(((Polygon)geometryFactory.toGeometry(this.envelope)).getExteriorRing());
                MultiLineString env = (MultiLineString)geometryFactory.createMultiLineString(voronoiBorderLines.toArray(new LineString[voronoiBorderLines.size()])).union();
                for (int i = 0; i < env.getNumGeometries(); ++i) {
                    lineStrings.add((LineString)env.getGeometryN(i));
                }
            }
            if (outputDimension == 1) {
                return geometryFactory.createMultiLineString(lineStrings.toArray(new LineString[lineStrings.size()]));
            }
            Polygonizer polygonizer = new Polygonizer();
            MultiLineString voronoiSegs = geometryFactory.createMultiLineString(lineStrings.toArray(new LineString[lineStrings.size()]));
            polygonizer.add((Geometry)voronoiSegs);
            return geometryFactory.createMultiPolygon(GeometryFactory.toPolygonArray((Collection)polygonizer.getPolygons()));
        }
        Coordinate[] circumcenters = new Coordinate[this.inputTriangles.getNumGeometries()];
        for (int idgeom = 0; idgeom < triangleCircumcenter.length; ++idgeom) {
            Geometry geomItem = this.inputTriangles.getGeometryN(idgeom);
            if (!(geomItem instanceof Polygon)) continue;
            circumcenters[idgeom] = this.getCircumcenter(idgeom, triangleCircumcenter);
        }
        MultiPoint result = geometryFactory.createMultiPoint(circumcenters);
        if (this.envelope == null) {
            return result;
        }
        return (GeometryCollection)geometryFactory.toGeometry(this.envelope).intersection((Geometry)result);
    }

    private int commonEdge(int originTriangle, EnvelopeWithIndex vert1, EnvelopeWithIndex vert2) {
        HashSet<Integer> commonTriangle = new HashSet<Integer>(vert1.getSharingTriangles());
        commonTriangle.retainAll(vert2.getSharingTriangles());
        commonTriangle.remove(originTriangle);
        if (commonTriangle.isEmpty()) {
            return -1;
        }
        return (Integer)commonTriangle.iterator().next();
    }

    private static class QuadTreeVisitor
    implements ItemVisitor {
        private EnvelopeWithIndex nearest = null;
        private double nearestDistance;
        private final double maxDist;
        private final Coordinate goal;

        public QuadTreeVisitor(double maxDist, Coordinate goal) {
            this.maxDist = maxDist;
            this.goal = goal;
        }

        public EnvelopeWithIndex getNearest() {
            return this.nearest;
        }

        public void visitItem(Object item) {
            EnvelopeWithIndex idx = (EnvelopeWithIndex)item;
            if (this.goal == idx.position) {
                this.nearest = idx;
                throw new RuntimeException("Found..");
            }
            double itemDistance = idx.position.distance(this.goal);
            if (itemDistance < this.maxDist && (this.nearest == null || this.nearestDistance > itemDistance)) {
                this.nearest = idx;
                this.nearestDistance = itemDistance;
            }
        }
    }

    private static class EnvelopeWithIndex {
        private int index;
        private Coordinate position;
        private Set<Integer> sharingTriangles = new HashSet<Integer>();

        public EnvelopeWithIndex(int index, Coordinate position) {
            this.index = index;
            this.position = position;
        }

        public void addSharingTriangle(int triangleId) {
            this.sharingTriangles.add(triangleId);
        }

        public Set<Integer> getSharingTriangles() {
            return Collections.unmodifiableSet(this.sharingTriangles);
        }
    }

    public static class Triple {
        private final int[] values = new int[3];

        public Triple() {
            this.values[0] = -1;
            this.values[1] = -1;
            this.values[2] = -1;
        }

        public Triple(int a, int b, int c) {
            this.values[0] = a;
            this.values[1] = b;
            this.values[2] = c;
        }

        public int getA() {
            return this.values[0];
        }

        public int getB() {
            return this.values[1];
        }

        public int getC() {
            return this.values[2];
        }

        int getNeighCount() {
            int neigh = 0;
            for (int value : this.values) {
                if (value == -1) continue;
                ++neigh;
            }
            return neigh;
        }

        int getArrayIndex(int value) {
            for (int val : this.values) {
                if (val != value) continue;
                return value;
            }
            return -1;
        }

        public int[] toArray() {
            return this.values;
        }

        public int get(int i) {
            return this.values[i];
        }

        public String toString() {
            return "Triangle(" + this.values[0] + "," + this.values[1] + "," + this.values[2] + ")";
        }

        public boolean contains(int value) {
            return this.getArrayIndex(value) != -1;
        }
    }
}

