/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.utilities.jts_utils;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Triangle;
import com.vividsolutions.jts.math.Vector2D;
import com.vividsolutions.jts.math.Vector3D;

public class TriMarkers
extends Triangle {
    private static double epsilon = 1.0E-12;
    double m1;
    double m2;
    double m3;

    public TriMarkers() {
        super(new Coordinate(), new Coordinate(), new Coordinate());
        this.m1 = 0.0;
        this.m2 = 0.0;
        this.m3 = 0.0;
    }

    public String toString() {
        return "TriMarkers{p1=" + this.p0 + ", p2=" + this.p1 + ", p3=" + this.p2 + " m1=" + this.m1 + ", m2=" + this.m2 + ", m3=" + this.m3 + "}";
    }

    public TriMarkers(Coordinate p0, Coordinate p1, Coordinate p2, double m1, double m2, double m3) {
        super(p0, p1, p2);
        if (!CGAlgorithms.isCCW((Coordinate[])this.getRing())) {
            this.setCoordinates(p2, p1, p0);
            this.m1 = m3;
            this.m3 = m1;
        } else {
            this.m1 = m1;
            this.m3 = m3;
        }
        this.m2 = m2;
    }

    void setMarkers(double m1, double m2, double m3) {
        this.m1 = m1;
        this.m2 = m2;
        this.m3 = m3;
    }

    void setAll(Coordinate p0, Coordinate p1, Coordinate p2, double m1, double m2, double m3) {
        this.setCoordinates(p0, p1, p2);
        this.setMarkers(m1, m2, m3);
        if (!CGAlgorithms.isCCW((Coordinate[])this.getRing())) {
            this.setCoordinates(p2, p1, p0);
            this.m1 = m3;
            this.m3 = m1;
        }
    }

    double getMinMarker() {
        return this.getMinMarker(-1);
    }

    double getMinMarker(int exception) {
        double minval = Double.POSITIVE_INFINITY;
        if (exception != 0) {
            minval = Math.min(minval, this.m1);
        }
        if (exception != 1) {
            minval = Math.min(minval, this.m2);
        }
        if (exception != 2) {
            minval = Math.min(minval, this.m3);
        }
        return minval;
    }

    double getMaxMarker() {
        return this.getMaxMarker(-1);
    }

    double getMaxMarker(int exception) {
        double maxval = Double.NEGATIVE_INFINITY;
        if (exception != 0) {
            maxval = Math.max(maxval, this.m1);
        }
        if (exception != 1) {
            maxval = Math.max(maxval, this.m2);
        }
        if (exception != 2) {
            maxval = Math.max(maxval, this.m3);
        }
        return maxval;
    }

    void setCoordinates(Coordinate p0, Coordinate p1, Coordinate p2) {
        this.p0 = p0;
        this.p1 = p1;
        this.p2 = p2;
    }

    Coordinate[] getRing() {
        return new Coordinate[]{this.p0, this.p1, this.p2, this.p0};
    }

    Coordinate getVertice(int idvert) {
        if (idvert == 0) {
            return this.p0;
        }
        if (idvert == 1) {
            return this.p1;
        }
        return this.p2;
    }

    double getMarker(int idvert) {
        if (idvert == 0) {
            return this.m1;
        }
        if (idvert == 1) {
            return this.m2;
        }
        return this.m3;
    }

    public static Vector3D getNormalVector(Triangle t) throws IllegalArgumentException {
        if (Double.isNaN(t.p0.z) || Double.isNaN(t.p1.z) || Double.isNaN(t.p2.z)) {
            throw new IllegalArgumentException("Z is required, cannot compute triangle normal of " + t);
        }
        double dx1 = t.p0.x - t.p1.x;
        double dy1 = t.p0.y - t.p1.y;
        double dz1 = t.p0.z - t.p1.z;
        double dx2 = t.p1.x - t.p2.x;
        double dy2 = t.p1.y - t.p2.y;
        double dz2 = t.p1.z - t.p2.z;
        return Vector3D.create((double)(dy1 * dz2 - dz1 * dy2), (double)(dz1 * dx2 - dx1 * dz2), (double)(dx1 * dy2 - dy1 * dx2)).normalize();
    }

    public static Vector3D getSteepestVector(Vector3D normal, double epsilon) {
        if (Math.abs(normal.getX()) < epsilon && Math.abs(normal.getY()) < epsilon) {
            return new Vector3D(0.0, 0.0, 0.0);
        }
        Vector3D slope = Math.abs(normal.getX()) < epsilon ? new Vector3D(0.0, 1.0, -normal.getY() / normal.getZ()) : (Math.abs(normal.getY()) < epsilon ? new Vector3D(1.0, 0.0, -normal.getX() / normal.getZ()) : new Vector3D(normal.getX() / normal.getY(), 1.0, -1.0 / normal.getZ() * (normal.getX() * normal.getX() / normal.getY() + normal.getY())));
        if (slope.getZ() > epsilon) {
            slope = new Vector3D(-slope.getX(), -slope.getY(), -slope.getZ());
        }
        return slope.normalize();
    }

    public static double getSlopeInPercent(Vector3D normal, double epsilon) {
        Vector3D vector = TriMarkers.getSteepestVector(normal, epsilon);
        if (Math.abs(vector.getZ()) < epsilon) {
            return 0.0;
        }
        return Math.abs(vector.getZ()) / new Vector2D(vector.getX(), vector.getY()).length() * 100.0;
    }

    public static boolean intersects(Coordinate p, Triangle t) {
        Vector2D v0 = new Vector2D(t.p0.x - t.p2.x, t.p0.y - t.p2.y);
        Vector2D v1 = new Vector2D(t.p1.x - t.p2.x, t.p1.y - t.p2.y);
        Vector2D v2 = new Vector2D(p.x - t.p2.x, p.y - t.p2.y);
        double dot00 = v0.dot(v0);
        double dot01 = v0.dot(v1);
        double dot02 = v0.dot(v2);
        double dot11 = v1.dot(v1);
        double dot12 = v1.dot(v2);
        double invDenom = 1.0 / (dot00 * dot11 - dot01 * dot01);
        double u = (dot11 * dot02 - dot01 * dot12) * invDenom;
        double v = (dot00 * dot12 - dot01 * dot02) * invDenom;
        return u > 0.0 - epsilon && v > 0.0 - epsilon && u + v < 1.0 + epsilon;
    }
}

