/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.utilities.jts_utils;

import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.h2gis.utilities.jts_utils.TriMarkers;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.TopologyException;

public class Contouring {
    private static final double EPSILON = 1.0E-15;
    private static final boolean CHECK_RESULT = true;

    private static boolean isoEqual(double isoValue1, double isoValue2) {
        return Math.abs(isoValue1 - isoValue2) < 1.0E-15 * isoValue2;
    }

    private static boolean computeSplitPositionOrdered(double marker1, double marker2, double isoValue, Coordinate p1, Coordinate p2, Coordinate splitPosition) {
        if (marker1 < isoValue && isoValue < marker2) {
            double interval = (isoValue - marker1) / (marker2 - marker1);
            splitPosition.setCoordinate(new Coordinate(p1.x + (p2.x - p1.x) * interval, p1.y + (p2.y - p1.y) * interval, p1.z + (p2.z - p1.z) * interval));
            return true;
        }
        return false;
    }

    private static boolean computeSplitPosition(double marker1, double marker2, double isoValue, Coordinate p1, Coordinate p2, Coordinate splitPosition) {
        if (marker1 < marker2) {
            return Contouring.computeSplitPositionOrdered(marker1, marker2, isoValue, p1, p2, splitPosition);
        }
        return Contouring.computeSplitPositionOrdered(marker2, marker1, isoValue, p2, p1, splitPosition);
    }

    private static short findTriangleSide(TriMarkers currentTriangle, double isoValue, short sideException, Coordinate splitPosition) {
        if (sideException != 0 && Contouring.computeSplitPosition(currentTriangle.m1, currentTriangle.m2, isoValue, currentTriangle.p0, currentTriangle.p1, splitPosition)) {
            return 0;
        }
        if (sideException != 1 && Contouring.computeSplitPosition(currentTriangle.m2, currentTriangle.m3, isoValue, currentTriangle.p1, currentTriangle.p2, splitPosition)) {
            return 1;
        }
        if (sideException != 2 && Contouring.computeSplitPosition(currentTriangle.m3, currentTriangle.m1, isoValue, currentTriangle.p2, currentTriangle.p0, splitPosition)) {
            return 2;
        }
        return -1;
    }

    private static short getSplittedTriangle(short sideStart, short sideStop, Coordinate posIsoStart, Coordinate posIsoStop, double isoLvl, TriMarkers currentTriangle, TriMarkers aloneTri, TriMarkers firstTwinTri, TriMarkers secondTwinTri) throws TopologyException {
        short sharedVertex;
        if (sideStart == 0 && sideStop == 2) {
            sharedVertex = 0;
            int secondVertex = 1;
            int thirdVertex = 2;
            aloneTri.setAll(posIsoStart, posIsoStop, currentTriangle.getVertice(sharedVertex), isoLvl, isoLvl, currentTriangle.getMarker(sharedVertex));
            firstTwinTri.setAll(posIsoStart, currentTriangle.getVertice(thirdVertex), posIsoStop, isoLvl, currentTriangle.getMarker(thirdVertex), isoLvl);
            secondTwinTri.setAll(posIsoStart, currentTriangle.getVertice(secondVertex), currentTriangle.getVertice(thirdVertex), isoLvl, currentTriangle.getMarker(secondVertex), currentTriangle.getMarker(thirdVertex));
        } else if (sideStart == 0 && sideStop == 1) {
            sharedVertex = 1;
            int secondVertex = 2;
            int thirdVertex = 0;
            aloneTri.setAll(posIsoStart, currentTriangle.getVertice(sharedVertex), posIsoStop, isoLvl, currentTriangle.getMarker(sharedVertex), isoLvl);
            firstTwinTri.setAll(posIsoStart, posIsoStop, currentTriangle.getVertice(thirdVertex), isoLvl, isoLvl, currentTriangle.getMarker(thirdVertex));
            secondTwinTri.setAll(posIsoStop, currentTriangle.getVertice(secondVertex), currentTriangle.getVertice(thirdVertex), isoLvl, currentTriangle.getMarker(secondVertex), currentTriangle.getMarker(thirdVertex));
        } else if (sideStart == 1 && sideStop == 2) {
            sharedVertex = 2;
            int secondVertex = 0;
            int thirdVertex = 1;
            aloneTri.setAll(posIsoStart, currentTriangle.getVertice(sharedVertex), posIsoStop, isoLvl, currentTriangle.getMarker(sharedVertex), isoLvl);
            firstTwinTri.setAll(posIsoStart, posIsoStop, currentTriangle.getVertice(secondVertex), isoLvl, isoLvl, currentTriangle.getMarker(secondVertex));
            secondTwinTri.setAll(posIsoStart, currentTriangle.getVertice(secondVertex), currentTriangle.getVertice(thirdVertex), isoLvl, currentTriangle.getMarker(secondVertex), currentTriangle.getMarker(thirdVertex));
        } else {
            throw new TopologyException("Can't find shared vertex");
        }
        return sharedVertex;
    }

    public static boolean splitInterval(double beginIncluded, double endExcluded, TriMarkers currentTriangle, Deque<TriMarkers> outsideTriangles, Deque<TriMarkers> intervalTriangles) throws TopologyException {
        if (beginIncluded > currentTriangle.getMaxMarker() || endExcluded < currentTriangle.getMinMarker()) {
            return false;
        }
        int vertIso1Start = -1;
        int vertIso1Stop = -1;
        int vertIso2Start = -1;
        int vertIso2Stop = -1;
        short sideIso1Start = -1;
        short sideIso1Stop = -1;
        short sideIso2Start = -1;
        short sideIso2Stop = -1;
        Coordinate posIso1Start = new Coordinate();
        Coordinate posIso1Stop = new Coordinate();
        Coordinate posIso2Start = new Coordinate();
        Coordinate posIso2Stop = new Coordinate();
        if (Contouring.isoEqual(currentTriangle.m1, beginIncluded)) {
            vertIso1Start = 0;
        }
        if (Contouring.isoEqual(currentTriangle.m2, beginIncluded)) {
            if (vertIso1Start == -1) {
                vertIso1Start = 1;
            } else {
                vertIso1Stop = 1;
            }
        }
        if (Contouring.isoEqual(currentTriangle.m3, beginIncluded)) {
            if (vertIso1Start == -1) {
                vertIso1Start = 2;
            } else {
                vertIso1Stop = 2;
            }
        }
        if ((vertIso1Start == -1 || vertIso1Stop == -1) && (sideIso1Start = Contouring.findTriangleSide(currentTriangle, beginIncluded, sideIso1Start, posIso1Start)) != -1) {
            sideIso1Stop = Contouring.findTriangleSide(currentTriangle, beginIncluded, sideIso1Start, posIso1Stop);
        }
        if (Contouring.isoEqual(currentTriangle.m1, endExcluded)) {
            vertIso2Start = 0;
        }
        if (Contouring.isoEqual(currentTriangle.m2, endExcluded)) {
            if (vertIso2Start == -1) {
                vertIso2Start = 1;
            } else {
                vertIso2Stop = 1;
            }
        }
        if (Contouring.isoEqual(currentTriangle.m3, endExcluded)) {
            if (vertIso2Start == -1) {
                vertIso2Start = 2;
            } else {
                vertIso2Stop = 2;
            }
        }
        if ((vertIso2Start == -1 || vertIso2Stop == -1) && (sideIso2Start = Contouring.findTriangleSide(currentTriangle, endExcluded, sideIso2Start, posIso2Start)) != -1) {
            sideIso2Stop = Contouring.findTriangleSide(currentTriangle, endExcluded, sideIso2Start, posIso2Stop);
        }
        if (sideIso1Start == -1 && sideIso2Start == -1 && (vertIso1Start != -1 && vertIso1Stop == -1 || vertIso2Start != -1 && vertIso2Stop == -1)) {
            if (vertIso1Start != -1 && currentTriangle.getMaxMarker(vertIso1Start) < beginIncluded || vertIso2Start != -1 && currentTriangle.getMinMarker(vertIso2Start) > endExcluded) {
                return false;
            }
            intervalTriangles.add(currentTriangle);
            return true;
        }
        if (vertIso1Start == -1 && sideIso1Start == -1 && vertIso2Start == -1 && sideIso2Start == -1 || vertIso1Start != -1 && vertIso1Stop != -1 && vertIso2Start != -1 || vertIso2Start != -1 && vertIso2Stop != -1 && vertIso1Start != -1) {
            intervalTriangles.add(currentTriangle);
            return true;
        }
        if ((vertIso1Start != -1 || sideIso1Start != -1) && vertIso2Start == -1 && sideIso2Start == -1 || vertIso1Start == -1 && sideIso1Start == -1) {
            if (sideIso1Start != -1 && sideIso1Stop != -1) {
                TriMarkers aloneTri = new TriMarkers();
                TriMarkers firstTwinTri = new TriMarkers();
                TriMarkers secondTwinTri = new TriMarkers();
                short sharedVertex = Contouring.getSplittedTriangle(sideIso1Start, sideIso1Stop, posIso1Start, posIso1Stop, beginIncluded, currentTriangle, aloneTri, firstTwinTri, secondTwinTri);
                if (currentTriangle.getMarker(sharedVertex) < beginIncluded) {
                    outsideTriangles.add(aloneTri);
                    intervalTriangles.add(firstTwinTri);
                    intervalTriangles.add(secondTwinTri);
                    return true;
                }
                intervalTriangles.add(aloneTri);
                outsideTriangles.add(firstTwinTri);
                outsideTriangles.add(secondTwinTri);
                return true;
            }
            if (sideIso2Start != -1 && sideIso2Stop != -1) {
                TriMarkers aloneTri = new TriMarkers();
                TriMarkers firstTwinTri = new TriMarkers();
                TriMarkers secondTwinTri = new TriMarkers();
                short sharedVertex = Contouring.getSplittedTriangle(sideIso2Start, sideIso2Stop, posIso2Start, posIso2Stop, endExcluded, currentTriangle, aloneTri, firstTwinTri, secondTwinTri);
                if (currentTriangle.getMarker(sharedVertex) > endExcluded) {
                    outsideTriangles.add(aloneTri);
                    intervalTriangles.add(firstTwinTri);
                    intervalTriangles.add(secondTwinTri);
                    return true;
                }
                intervalTriangles.add(aloneTri);
                outsideTriangles.add(firstTwinTri);
                outsideTriangles.add(secondTwinTri);
                return true;
            }
            if (vertIso1Start != -1 && vertIso1Stop != -1 || vertIso2Start != -1 && vertIso2Stop != -1) {
                int thirdVert = -1;
                if (vertIso1Start != 0 && vertIso2Start != 0) {
                    thirdVert = 0;
                }
                if (vertIso1Start != 1 && vertIso1Stop != 1 && vertIso2Start != 1 && vertIso2Stop != 1) {
                    thirdVert = 1;
                }
                if (vertIso1Stop != 2 && vertIso2Stop != 2) {
                    thirdVert = 2;
                }
                if (currentTriangle.getMarker(thirdVert) >= beginIncluded && currentTriangle.getMarker(thirdVert) < endExcluded) {
                    intervalTriangles.add(currentTriangle);
                    return true;
                }
                return false;
            }
            if (vertIso1Start != -1) {
                int vertOutside = -1;
                int vertInside = -1;
                if (currentTriangle.m1 < beginIncluded) {
                    vertOutside = 0;
                    vertInside = vertIso1Start == 1 ? 2 : 1;
                } else if (currentTriangle.m2 < beginIncluded) {
                    vertOutside = 1;
                    vertInside = vertIso1Start == 0 ? 2 : 0;
                } else if (currentTriangle.m3 < beginIncluded) {
                    vertOutside = 2;
                    vertInside = vertIso1Start == 0 ? 1 : 0;
                }
                outsideTriangles.add(new TriMarkers(currentTriangle.getVertice(vertIso1Start), currentTriangle.getVertice(vertOutside), posIso1Start, beginIncluded, currentTriangle.getMarker(vertOutside), beginIncluded));
                intervalTriangles.add(new TriMarkers(currentTriangle.getVertice(vertIso1Start), currentTriangle.getVertice(vertInside), posIso1Start, beginIncluded, currentTriangle.getMarker(vertInside), beginIncluded));
                return true;
            }
            if (vertIso2Start != -1) {
                int vertOutside = -1;
                int vertInside = -1;
                double maxMarker = currentTriangle.getMaxMarker();
                if (Contouring.isoEqual(currentTriangle.m1, maxMarker)) {
                    vertOutside = 0;
                    vertInside = vertIso2Start == 1 ? 2 : 1;
                } else if (Contouring.isoEqual(currentTriangle.m2, maxMarker)) {
                    vertOutside = 1;
                    vertInside = vertIso2Start == 0 ? 2 : 0;
                } else {
                    vertOutside = 2;
                    vertInside = vertIso2Start == 0 ? 1 : 0;
                }
                TriMarkers outsideTriangle = new TriMarkers(currentTriangle.getVertice(vertIso2Start), currentTriangle.getVertice(vertOutside), posIso2Start, endExcluded, currentTriangle.getMarker(vertOutside), endExcluded);
                TriMarkers intervalTriangle = new TriMarkers(currentTriangle.getVertice(vertIso2Start), currentTriangle.getVertice(vertInside), posIso2Start, endExcluded, currentTriangle.getMarker(vertInside), endExcluded);
                if (!(intervalTriangle.getMinMarker() >= beginIncluded) || !(intervalTriangle.getMaxMarker() <= endExcluded)) {
                    throw new TopologyException("Computation error out of bound triangle");
                }
                if (outsideTriangle.getMaxMarker() < endExcluded) {
                    throw new TopologyException("Computation error out of bound triangle");
                }
                outsideTriangles.add(outsideTriangle);
                intervalTriangles.add(intervalTriangle);
                return true;
            }
        } else {
            LinkedList<TriMarkers> insideTriangles = new LinkedList<TriMarkers>();
            Contouring.splitInterval(beginIncluded, Double.POSITIVE_INFINITY, currentTriangle, outsideTriangles, insideTriangles);
            for (TriMarkers insideTri : insideTriangles) {
                Contouring.splitInterval(Double.NEGATIVE_INFINITY, endExcluded, insideTri, outsideTriangles, intervalTriangles);
            }
            return true;
        }
        throw new TopologyException("Unhandled triangle splitting case :\n vertIso1Start(" + vertIso1Start + "), vertIso1Stop(" + vertIso1Stop + "), vertIso2Start(" + vertIso2Start + "), vertIso2Stop(" + vertIso2Stop + "), sideIso1Start(" + sideIso1Start + "), sideIso1Stop(" + sideIso1Stop + "), sideIso2Start(" + sideIso2Start + "), sideIso2Stop(" + sideIso2Stop + ")");
    }

    public static Map<Short, Deque<TriMarkers>> processTriangle(TriMarkers triangleData, List<Double> isoLvls) throws TopologyException {
        TriMarkers currentTriangle = triangleData;
        HashMap<Short, Deque<TriMarkers>> toDriver = new HashMap<Short, Deque<TriMarkers>>();
        LinkedList<TriMarkers> triangleToProcess = new LinkedList<TriMarkers>();
        triangleToProcess.add(currentTriangle);
        block0: do {
            currentTriangle = (TriMarkers)((Object)triangleToProcess.pop());
            Double beginInterval = Double.NEGATIVE_INFINITY;
            short isolvl = 0;
            for (Double endInterval : isoLvls) {
                LinkedList<TriMarkers> triangleToDriver;
                if (!toDriver.containsKey(isolvl)) {
                    triangleToDriver = new LinkedList();
                    toDriver.put(isolvl, triangleToDriver);
                } else {
                    triangleToDriver = (Deque)toDriver.get(isolvl);
                }
                if (Contouring.splitInterval(beginInterval, endInterval, currentTriangle, triangleToProcess, triangleToDriver)) continue block0;
                beginInterval = endInterval;
                isolvl = (short)(isolvl + 1);
            }
        } while (!triangleToProcess.isEmpty());
        return toDriver;
    }
}

