/**
 * H2GIS is a library that brings spatial support to the H2 Database Engine
 * <http://www.h2database.com>. H2GIS is developed by CNRS
 * <http://www.cnrs.fr/>.
 *
 * This code is part of the H2GIS project. H2GIS is free software; 
 * you can redistribute it and/or modify it under the terms of the GNU
 * Lesser General Public License as published by the Free Software Foundation;
 * version 3.0 of the License.
 *
 * H2GIS is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details <http://www.gnu.org/licenses/>.
 *
 *
 * For more information, please consult: <http://www.h2gis.org/>
 * or contact directly: info_at_h2gis.org
 */

package org.h2gis.functions.spatial.type;

/**
 * Class helper to define domain. Use defined type
 * @author Nicolas Fortin
 */
public class DomainInfo {
    /** Type alias name */
    private String domainName;
    /** Constraint function associated with this type */
    private int geometryTypeCode;

    /**
     * @param domainName Type alias name
     * @param geometryTypeCode  associated with this type
     */
    public DomainInfo(String domainName, int geometryTypeCode) {
        this.domainName = domainName;
        this.geometryTypeCode = geometryTypeCode;
    }

    /**
     * @return Type alias
     */
    public String getDomainName() {
        return domainName;
    }

    /**
     * @return Return one of {@link }
     */
    public int getGeometryTypeCode() {
        return geometryTypeCode;
    }
}
