/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.gpx;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.h2gis.api.DriverFunction;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.functions.io.gpx.model.GPXTablesFactory;
import org.h2gis.functions.io.gpx.model.GpxParser;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;

public class GPXDriverFunction
implements DriverFunction {
    public static String DESCRIPTION = "GPX file (1.1 and 1.0)";

    public DriverFunction.IMPORT_DRIVER_TYPE getImportDriverType() {
        return DriverFunction.IMPORT_DRIVER_TYPE.COPY;
    }

    public String[] getImportFormats() {
        return new String[]{"gpx"};
    }

    public String[] getExportFormats() {
        return new String[0];
    }

    public String getFormatDescription(String format) {
        if (format.equalsIgnoreCase("gpx")) {
            return DESCRIPTION;
        }
        return "";
    }

    public boolean isSpatialFormat(String extension) {
        return extension.equalsIgnoreCase("gpx");
    }

    public void exportTable(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        this.importFile(connection, tableReference, fileName, progress, false);
    }

    public void importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress, boolean deleteTables) throws SQLException, IOException {
        boolean isH2 = JDBCUtilities.isH2DataBase((DatabaseMetaData)connection.getMetaData());
        if (fileName.length() == 0L) {
            JDBCUtilities.createEmptyTable((Connection)connection, (String)TableLocation.parse((String)tableReference, (Boolean)isH2).toString());
        } else {
            if (deleteTables) {
                GPXTablesFactory.dropOSMTables(connection, isH2, tableReference);
            }
            GpxParser gpd = new GpxParser();
            gpd.read(fileName, tableReference, connection);
        }
    }
}

