/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.gpx.model;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.h2gis.functions.io.gpx.model.AbstractGpxParser;
import org.h2gis.functions.io.gpx.model.AbstractGpxParserDefault;
import org.h2gis.functions.io.gpx.model.GPXCoordinate;
import org.h2gis.functions.io.gpx.model.GPXPoint;
import org.h2gis.functions.io.gpx.model.GPXTags;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class AbstractGpxParserRte
extends AbstractGpxParser {
    private boolean point;
    private AbstractGpxParserDefault parent;
    private List<Coordinate> rteList;
    private int idRtPt = 1;

    public void initialise(XMLReader reader, AbstractGpxParserDefault parent) {
        this.setReader(reader);
        this.setParent(parent);
        this.setContentBuffer(parent.getContentBuffer());
        this.setRtePreparedStmt(parent.getRtePreparedStmt());
        this.setRteptPreparedStmt(parent.getRteptPreparedStmt());
        this.setElementNames(parent.getElementNames());
        this.setCurrentLine(parent.getCurrentLine());
        this.setRteList(new ArrayList<Coordinate>());
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (localName.equalsIgnoreCase(GPXTags.RTEPT)) {
            this.point = true;
            GPXPoint routePoint = new GPXPoint(25);
            try {
                Coordinate coordinate = GPXCoordinate.createCoordinate(attributes);
                Point geom = this.getGeometryFactory().createPoint(coordinate);
                geom.setSRID(4326);
                routePoint.setValue(0, geom);
                routePoint.setValue(2, coordinate.y);
                routePoint.setValue(3, coordinate.x);
                routePoint.setValue(4, coordinate.z);
                routePoint.setValue(1, this.idRtPt++);
                routePoint.setValue(24, this.getCurrentLine().getValues()[1]);
                this.rteList.add(coordinate);
            }
            catch (NumberFormatException ex) {
                throw new SAXException(ex);
            }
            this.setCurrentPoint(routePoint);
        }
        this.getContentBuffer().delete(0, this.getContentBuffer().length());
        this.getElementNames().push(qName);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.setCurrentElement(this.getElementNames().pop());
        if (this.getCurrentElement().equalsIgnoreCase(GPXTags.RTE)) {
            Coordinate[] rteArray = new Coordinate[this.rteList.size()];
            rteArray = this.rteList.toArray(rteArray);
            if (this.rteList.size() > 1) {
                LineString geometry = this.getGeometryFactory().createLineString(rteArray);
                geometry.setSRID(4326);
                this.getCurrentLine().setGeometry((Geometry)geometry);
            }
            try {
                Object[] values;
                PreparedStatement pStm = this.getRtePreparedStmt();
                int i = 1;
                for (Object object : values = this.getCurrentLine().getValues()) {
                    pStm.setObject(i, object);
                    ++i;
                }
                pStm.execute();
            }
            catch (SQLException ex) {
                throw new SAXException("Cannot import the route line ", ex);
            }
            this.getReader().setContentHandler(this.parent);
        } else if (this.getCurrentElement().equalsIgnoreCase(GPXTags.RTEPT)) {
            this.point = false;
            try {
                Object[] values;
                PreparedStatement pStm = this.getRteptPreparedStmt();
                int i = 1;
                for (Object object : values = this.getCurrentPoint().getValues()) {
                    pStm.setObject(i, object);
                    ++i;
                }
                pStm.execute();
            }
            catch (SQLException ex) {
                throw new SAXException("Cannot import the route points ", ex);
            }
        } else if (this.point) {
            this.getCurrentPoint().setAttribute(this.getCurrentElement(), this.getContentBuffer());
        } else {
            this.getCurrentLine().setAttribute(this.getCurrentElement(), this.getContentBuffer());
        }
    }

    public void setParent(AbstractGpxParserDefault parent) {
        this.parent = parent;
    }

    public boolean isPoint() {
        return this.point;
    }

    public void setRteList(List<Coordinate> rteList) {
        this.rteList = rteList;
    }
}

