/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.gpx.model;

import com.vividsolutions.jts.geom.Geometry;
import org.h2gis.functions.io.gpx.model.GPXTags;
import org.xml.sax.Attributes;

public class GPXLine {
    private Object[] lineValues;

    public GPXLine(int numberOfValues) {
        this.lineValues = new Object[numberOfValues];
    }

    public final void setGeometry(Geometry geometry) {
        this.lineValues[0] = geometry;
    }

    public final void setAttribute(String currentElement, StringBuilder contentBuffer) {
        if (currentElement.equalsIgnoreCase(GPXTags.NAME)) {
            this.setName(contentBuffer);
        } else if (currentElement.equalsIgnoreCase(GPXTags.CMT)) {
            this.setCmt(contentBuffer);
        } else if (currentElement.equalsIgnoreCase(GPXTags.DESC)) {
            this.setDesc(contentBuffer);
        } else if (currentElement.equalsIgnoreCase(GPXTags.SRC)) {
            this.setSrc(contentBuffer);
        } else if (currentElement.equalsIgnoreCase(GPXTags.NUMBER)) {
            this.setNumber(contentBuffer);
        } else if (currentElement.equalsIgnoreCase(GPXTags.TYPE)) {
            this.setType(contentBuffer);
        } else if (currentElement.equalsIgnoreCase(GPXTags.EXTENSIONS)) {
            this.setExtensions();
        }
    }

    public final void setName(StringBuilder contentBuffer) {
        this.lineValues[2] = contentBuffer.toString();
    }

    public final void setCmt(StringBuilder contentBuffer) {
        this.lineValues[3] = contentBuffer.toString();
    }

    public final void setDesc(StringBuilder contentBuffer) {
        this.lineValues[4] = contentBuffer.toString();
    }

    public final void setSrc(StringBuilder contentBuffer) {
        this.lineValues[5] = contentBuffer.toString();
    }

    public final void setLink(Attributes attributes) {
        this.lineValues[6] = attributes.getValue(GPXTags.HREF);
    }

    public final void setLink(StringBuilder contentBuffer) {
        this.lineValues[6] = contentBuffer.toString();
    }

    public final void setLinkText(StringBuilder contentBuffer) {
        this.lineValues[7] = contentBuffer.toString();
    }

    public final void setNumber(StringBuilder contentBuffer) {
        this.lineValues[8] = Integer.parseInt(contentBuffer.toString());
    }

    public final void setType(StringBuilder contentBuffer) {
        this.lineValues[9] = contentBuffer.toString();
    }

    public final void setExtensions() {
        this.lineValues[10] = true;
    }

    public final Object[] getValues() {
        return this.lineValues;
    }

    public final void setValue(int i, Object value) {
        this.lineValues[i] = value;
    }
}

