/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.json;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.functions.io.utility.FileUtil;
import org.h2gis.utilities.JDBCUtilities;

public class JsonWriteDriver {
    private final String tableName;
    private final File fileName;
    private final Connection connection;

    public JsonWriteDriver(Connection connection, String tableName, File fileName) {
        this.connection = connection;
        this.tableName = tableName;
        this.fileName = fileName;
    }

    public void write(ProgressVisitor progress) throws SQLException, IOException {
        if (!FileUtil.isExtensionWellFormated(this.fileName, "json")) {
            throw new SQLException("Only .json extension is supported");
        }
        this.writeJson(progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJson(ProgressVisitor progress) throws SQLException, IOException {
        block52: {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(this.fileName);
                int recordCount = JDBCUtilities.getRowCount((Connection)this.connection, (String)this.tableName);
                if (recordCount <= 0) break block52;
                try (Statement st = this.connection.createStatement();){
                    JsonFactory jsonFactory = new JsonFactory();
                    JsonGenerator jsonGenerator = jsonFactory.createGenerator((OutputStream)new BufferedOutputStream(fos), JsonEncoding.UTF8);
                    try (ResultSet rs = st.executeQuery(String.format("select * from %s", this.tableName));){
                        ResultSetMetaData rsmd = rs.getMetaData();
                        int numColumns = rsmd.getColumnCount();
                        ProgressVisitor copyProgress = progress.subProcess(recordCount);
                        while (rs.next()) {
                            jsonGenerator.writeStartObject();
                            block49: for (int i = 1; i < numColumns + 1; ++i) {
                                String column_name = rsmd.getColumnName(i);
                                switch (rsmd.getColumnType(i)) {
                                    case 2003: {
                                        Object[] values = (Object[])rs.getArray(i).getArray();
                                        if (values == null) continue block49;
                                        jsonGenerator.writeArrayFieldStart(column_name);
                                        for (Object value : values) {
                                            jsonGenerator.writeObject(value);
                                        }
                                        jsonGenerator.writeEndArray();
                                        continue block49;
                                    }
                                    case -5: {
                                        jsonGenerator.writeObjectField(column_name, (Object)rs.getLong(i));
                                        continue block49;
                                    }
                                    case 7: {
                                        jsonGenerator.writeObjectField(column_name, (Object)Float.valueOf(rs.getFloat(i)));
                                        continue block49;
                                    }
                                    case 16: {
                                        jsonGenerator.writeObjectField(column_name, (Object)rs.getBoolean(i));
                                        continue block49;
                                    }
                                    case 2004: {
                                        jsonGenerator.writeObjectField(column_name, (Object)rs.getBlob(i));
                                        continue block49;
                                    }
                                    case 8: {
                                        jsonGenerator.writeObjectField(column_name, (Object)rs.getDouble(i));
                                        continue block49;
                                    }
                                    case 6: {
                                        jsonGenerator.writeObjectField(column_name, (Object)rs.getDouble(i));
                                        continue block49;
                                    }
                                    case 4: {
                                        jsonGenerator.writeObjectField(column_name, (Object)rs.getInt(i));
                                        continue block49;
                                    }
                                    case -9: {
                                        jsonGenerator.writeObjectField(column_name, (Object)rs.getNString(i));
                                        continue block49;
                                    }
                                    case 12: {
                                        jsonGenerator.writeObjectField(column_name, (Object)rs.getString(i));
                                        continue block49;
                                    }
                                    case 1: {
                                        jsonGenerator.writeObjectField(column_name, (Object)rs.getString(i));
                                        continue block49;
                                    }
                                    case -15: {
                                        jsonGenerator.writeObjectField(column_name, (Object)rs.getNString(i));
                                        continue block49;
                                    }
                                    case -16: {
                                        jsonGenerator.writeObjectField(column_name, (Object)rs.getNString(i));
                                        continue block49;
                                    }
                                    case -1: {
                                        jsonGenerator.writeObjectField(column_name, (Object)rs.getString(i));
                                        continue block49;
                                    }
                                    case -6: {
                                        jsonGenerator.writeObjectField(column_name, (Object)rs.getByte(i));
                                        continue block49;
                                    }
                                    case 5: {
                                        jsonGenerator.writeObjectField(column_name, (Object)rs.getShort(i));
                                        continue block49;
                                    }
                                    case 91: {
                                        jsonGenerator.writeObjectField(column_name, (Object)rs.getDate(i));
                                        continue block49;
                                    }
                                    case 92: {
                                        jsonGenerator.writeObjectField(column_name, (Object)rs.getTime(i));
                                        continue block49;
                                    }
                                    case 93: {
                                        jsonGenerator.writeObjectField(column_name, (Object)rs.getTimestamp(i));
                                        continue block49;
                                    }
                                    case -2: {
                                        jsonGenerator.writeObjectField(column_name, (Object)rs.getBytes(i));
                                        continue block49;
                                    }
                                    case -3: {
                                        jsonGenerator.writeObjectField(column_name, (Object)rs.getBytes(i));
                                        continue block49;
                                    }
                                    case -4: {
                                        jsonGenerator.writeObjectField(column_name, (Object)rs.getBinaryStream(i));
                                        continue block49;
                                    }
                                    case -7: {
                                        jsonGenerator.writeObjectField(column_name, (Object)rs.getBoolean(i));
                                        continue block49;
                                    }
                                    case 2005: {
                                        jsonGenerator.writeObjectField(column_name, (Object)rs.getClob(i));
                                        continue block49;
                                    }
                                    case 2: {
                                        jsonGenerator.writeObjectField(column_name, (Object)rs.getBigDecimal(i));
                                        continue block49;
                                    }
                                    case 3: {
                                        jsonGenerator.writeObjectField(column_name, (Object)rs.getBigDecimal(i));
                                        continue block49;
                                    }
                                    case 70: {
                                        jsonGenerator.writeObjectField(column_name, (Object)rs.getURL(i));
                                        continue block49;
                                    }
                                    case 2006: {
                                        jsonGenerator.writeObjectField(column_name, (Object)rs.getRef(i));
                                        continue block49;
                                    }
                                    case 2002: {
                                        jsonGenerator.writeObjectField(column_name, rs.getObject(i));
                                        continue block49;
                                    }
                                    case 2001: {
                                        jsonGenerator.writeObjectField(column_name, rs.getObject(i));
                                        continue block49;
                                    }
                                    case 2000: {
                                        jsonGenerator.writeObjectField(column_name, rs.getObject(i));
                                        continue block49;
                                    }
                                    default: {
                                        jsonGenerator.writeObjectField(column_name, (Object)rs.getString(i));
                                    }
                                }
                            }
                            jsonGenerator.writeEndObject();
                            copyProgress.endStep();
                        }
                        copyProgress.endOfProgress();
                        jsonGenerator.flush();
                        jsonGenerator.close();
                    }
                }
            }
            catch (FileNotFoundException ex) {
                throw new SQLException(ex);
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException ex) {
                    throw new SQLException(ex);
                }
            }
        }
    }
}

