/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.crs;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.Geometry;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.cts.CRSFactory;
import org.cts.IllegalCoordinateException;
import org.cts.crs.CRSException;
import org.cts.crs.CoordinateReferenceSystem;
import org.cts.crs.GeodeticCRS;
import org.cts.op.CoordinateOperation;
import org.cts.op.CoordinateOperationFactory;
import org.cts.registry.Registry;
import org.h2gis.api.AbstractFunction;
import org.h2gis.api.ScalarFunction;
import org.h2gis.functions.spatial.crs.EPSGTuple;
import org.h2gis.functions.spatial.crs.SpatialRefRegistry;

public class ST_Transform
extends AbstractFunction
implements ScalarFunction {
    private static CRSFactory crsf;
    private static SpatialRefRegistry srr;
    private static Map<EPSGTuple, CoordinateOperation> copPool;

    public ST_Transform() {
        this.addProperty("remarks", "Transform a geometry from one CRS to another using integer codes from the SPATIAL_REF_SYS table.");
    }

    public String getJavaStaticMethod() {
        return "ST_Transform";
    }

    public static Geometry ST_Transform(Connection connection, Geometry geom, Integer codeEpsg) throws SQLException {
        block16: {
            if (geom == null) {
                return null;
            }
            if (codeEpsg == null) {
                throw new IllegalArgumentException("The SRID code cannot be null.");
            }
            if (crsf == null) {
                crsf = new CRSFactory();
                crsf.getRegistryManager().addRegistry((Registry)srr);
            }
            srr.setConnection(connection);
            try {
                CoordinateReferenceSystem targetCRS;
                int inputSRID = geom.getSRID();
                if (inputSRID == 0) {
                    throw new SQLException("Cannot find a CRS");
                }
                CoordinateReferenceSystem inputCRS = crsf.getCRS(srr.getRegistryName() + ":" + String.valueOf(inputSRID));
                if (inputCRS.equals(targetCRS = crsf.getCRS(srr.getRegistryName() + ":" + String.valueOf(codeEpsg)))) {
                    Geometry geometry = geom;
                    return geometry;
                }
                EPSGTuple epsg = new EPSGTuple(inputSRID, codeEpsg);
                CoordinateOperation op = copPool.get(epsg);
                if (op != null) {
                    Geometry outPutGeom = (Geometry)geom.clone();
                    outPutGeom.geometryChanged();
                    outPutGeom.apply((CoordinateFilter)new CRSTransformFilter(op));
                    outPutGeom.setSRID(codeEpsg.intValue());
                    Geometry geometry = outPutGeom;
                    return geometry;
                }
                if (inputCRS instanceof GeodeticCRS && targetCRS instanceof GeodeticCRS) {
                    List ops = CoordinateOperationFactory.createCoordinateOperations((GeodeticCRS)((GeodeticCRS)inputCRS), (GeodeticCRS)((GeodeticCRS)targetCRS));
                    if (!ops.isEmpty()) {
                        op = (CoordinateOperation)ops.get(0);
                        Geometry outPutGeom = (Geometry)geom.clone();
                        outPutGeom.geometryChanged();
                        outPutGeom.apply((CoordinateFilter)new CRSTransformFilter(op));
                        copPool.put(epsg, op);
                        outPutGeom.setSRID(codeEpsg.intValue());
                        Geometry geometry = outPutGeom;
                        return geometry;
                    }
                    break block16;
                }
                throw new SQLException("The transformation from " + inputCRS + " to " + codeEpsg + " is not yet supported.");
            }
            catch (CRSException ex) {
                throw new SQLException("Cannot create the CRS", ex);
            }
            finally {
                srr.setConnection(null);
            }
        }
        return null;
    }

    static {
        srr = new SpatialRefRegistry();
        copPool = new CopCache(5);
    }

    public static class CopCache
    extends LinkedHashMap<EPSGTuple, CoordinateOperation> {
        private final int limit;

        public CopCache(int limit) {
            super(16, 0.75f, true);
            this.limit = limit;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<EPSGTuple, CoordinateOperation> eldest) {
            return this.size() > this.limit;
        }
    }

    public static class CRSTransformFilter
    implements CoordinateFilter {
        private final CoordinateOperation coordinateOperation;

        public CRSTransformFilter(CoordinateOperation coordinateOperation) {
            this.coordinateOperation = coordinateOperation;
        }

        public void filter(Coordinate coord) {
            try {
                if (Double.isNaN(coord.z)) {
                    coord.z = 0.0;
                }
                double[] xyz = this.coordinateOperation.transform(new double[]{coord.x, coord.y, coord.z});
                coord.x = xyz[0];
                coord.y = xyz[1];
                coord.z = xyz.length > 2 ? xyz[2] : Double.NaN;
            }
            catch (IllegalCoordinateException ice) {
                throw new RuntimeException("Cannot transform the coordinate" + coord.toString(), ice);
            }
        }
    }
}

