/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.earth;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.math.Vector2D;
import java.util.List;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.utilities.jts_utils.CoordinateUtils;

public class ST_Svf
extends DeterministicScalarFunction {
    private static int RAY_STEP_LENGTH = 10;

    public ST_Svf() {
        this.addProperty("remarks", "Return the Sky View Factor (SVF) for a given point.\npt = Point coordinates (x, y, z) - the SVF is calculated from this point\ngeoms = Geometries used as sky obstacles (z coordinates should be given and not NaN)\ndistance = Only obstacles located within this distance from pt are considered in the calculation (double - in meters)\nrayCount = Number of ray considered for the calculation (integer - number of direction of calculation)\nAn optional argument may be passed:\nRAY_STEP_LENGTH = 10 (default) Each ray is subdivided to make the calculation faster. This argument set\nthe length of each subdivision");
    }

    public String getJavaStaticMethod() {
        return "computeSvf";
    }

    public static double computeSvf(Point pt, Geometry geoms, double distance, int rayCount) {
        return ST_Svf.computeSvf(pt, geoms, distance, rayCount, RAY_STEP_LENGTH);
    }

    public static double computeSvf(Point pt, Geometry geoms, double distance, int rayCount, int stepRayLength) {
        double svf = -1.0;
        if (pt == null) {
            return svf;
        }
        if (geoms == null) {
            return svf;
        }
        if (distance <= 0.0) {
            throw new IllegalArgumentException("The distance value must be greater than 0");
        }
        if (rayCount < 4) {
            throw new IllegalArgumentException("The number of rays must be greater than or equal to 4");
        }
        if (stepRayLength <= 0) {
            throw new IllegalArgumentException("The ray length parameter must be greater than 0");
        }
        RAY_STEP_LENGTH = stepRayLength;
        if (geoms.getDimension() > 0) {
            GeometryFactory factory = pt.getFactory();
            STRtree sTRtree = new STRtree();
            int nbGeoms = geoms.getNumGeometries();
            for (int i = 0; i < nbGeoms; ++i) {
                Geometry subGeom = geoms.getGeometryN(i);
                if (subGeom instanceof LineString) {
                    ST_Svf.addSegments(subGeom.getCoordinates(), factory, sTRtree);
                    continue;
                }
                if (!(subGeom instanceof Polygon)) continue;
                Polygon p = (Polygon)subGeom;
                ST_Svf.addSegments(p.getExteriorRing().getCoordinates(), factory, sTRtree);
                int nbInterior = p.getNumInteriorRing();
                for (int j = 0; j < nbInterior; ++j) {
                    ST_Svf.addSegments(p.getInteriorRingN(j).getCoordinates(), factory, sTRtree);
                }
            }
            Coordinate startCoordinate = pt.getCoordinate();
            double startZ = Double.isNaN(startCoordinate.z) ? 0.0 : startCoordinate.z;
            double sumArea = Math.PI * 2;
            double elementaryAngle = sumArea / (double)rayCount;
            int stepCount = (int)Math.round(distance / (double)RAY_STEP_LENGTH);
            double stepLength = distance / (double)stepCount;
            for (int i = 0; i < rayCount; ++i) {
                Vector2D vStart = new Vector2D(startCoordinate);
                double angleRad = elementaryAngle * (double)i;
                Vector2D v = Vector2D.create((double)Math.cos(angleRad), (double)Math.sin(angleRad));
                v = v.multiply(stepLength);
                double max = 0.0;
                for (int j = 0; j < stepCount; ++j) {
                    LineSegment stepLine = new LineSegment(vStart.add(v.multiply((double)j)).toCoordinate(), vStart.add(v.multiply((double)(j + 1))).toCoordinate());
                    LineString rayStep = stepLine.toGeometry(factory);
                    List interEnv = sTRtree.query(rayStep.getEnvelopeInternal());
                    if (interEnv.isEmpty()) continue;
                    for (LineString lineGeoms : interEnv) {
                        double distancePoint;
                        double coordWithZ;
                        double ratio;
                        Geometry ptsIntersect;
                        Coordinate[] coords = lineGeoms.getCoordinates();
                        Coordinate coordsStart = coords[0];
                        Coordinate coordsEnd = coords[1];
                        if (!(Math.max(coordsStart.z, coordsEnd.z) > max * (double)j * stepLength) || !((ptsIntersect = lineGeoms.intersection((Geometry)rayStep)) instanceof Point) || ptsIntersect == null || !((ratio = ((coordWithZ = CoordinateUtils.interpolate((Coordinate)lineGeoms.getCoordinateN(0), (Coordinate)lineGeoms.getCoordinateN(1), (Coordinate)ptsIntersect.getCoordinate())) - startZ) / (distancePoint = ptsIntersect.distance((Geometry)pt))) > max)) continue;
                        max = ratio;
                    }
                }
                double sinTheta = Math.sin(Math.atan(max));
                sumArea -= elementaryAngle * sinTheta * sinTheta;
            }
            svf = sumArea / (Math.PI * 2);
        }
        return svf;
    }

    public static void addSegments(Coordinate[] coords, GeometryFactory factory, STRtree strtree) {
        for (int j = 0; j < coords.length - 1; ++j) {
            Coordinate startCoord = coords[j];
            Coordinate endCoord = coords[j + 1];
            if (Double.isNaN(startCoord.z) || Double.isNaN(endCoord.z)) continue;
            LineString lineString = factory.createLineString(new Coordinate[]{startCoord, endCoord});
            strtree.insert(lineString.getEnvelopeInternal(), (Object)lineString);
        }
    }
}

