/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.properties;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.h2.tools.SimpleResultSet;
import org.h2.tools.SimpleRowSource;
import org.h2gis.api.AbstractFunction;
import org.h2gis.api.ScalarFunction;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.SFSUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.TableUtilities;

public class ST_Explode
extends AbstractFunction
implements ScalarFunction {
    public static final String EXPLODE_FIELD = "EXPLOD_ID";

    public ST_Explode() {
        this.addProperty("remarks", "Explode Geometry Collection into multiple geometries.\nNote : This function supports select query as the first arfument.");
        this.addProperty("nobuffer", true);
    }

    public String getJavaStaticMethod() {
        return "explode";
    }

    public static ResultSet explode(Connection connection, String tableName) throws SQLException {
        String regex = ".*(?i)\\b(select|from)\\b.*";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(tableName);
        if (matcher.find()) {
            if (tableName.startsWith("(") && tableName.endsWith(")")) {
                ExplodeResultSetQuery explodeResultSetQuery = new ExplodeResultSetQuery(connection, tableName, null);
                return explodeResultSetQuery.getResultSet();
            }
            throw new SQLException("The select query must be enclosed in parenthesis: '(SELECT * FROM ORDERS)'.");
        }
        return ST_Explode.explode(connection, tableName, null);
    }

    public static ResultSet explode(Connection connection, String tableName, String fieldName) throws SQLException {
        ExplodeResultSet rowSource = new ExplodeResultSet(connection, TableLocation.parse((String)tableName, (Boolean)JDBCUtilities.isH2DataBase((DatabaseMetaData)connection.getMetaData())).toString(), fieldName);
        return rowSource.getResultSet();
    }

    public static class ExplodeResultSetQuery
    extends ExplodeResultSet {
        public ExplodeResultSetQuery(Connection connection, String tableName, String spatialFieldName) {
            super(connection, tableName, spatialFieldName);
        }

        @Override
        public void reset() throws SQLException {
            if (this.tableQuery != null && !this.tableQuery.isClosed()) {
                this.close();
            }
            Statement st = this.connection.createStatement();
            this.tableQuery = st.executeQuery(this.tableName);
            this.firstRow = false;
        }

        @Override
        public ResultSet getResultSet() throws SQLException {
            SimpleResultSet rs = new SimpleResultSet((SimpleRowSource)this);
            this.copyfields(rs, this.tableName);
            rs.addColumn(ST_Explode.EXPLODE_FIELD, 4, 10, 0);
            return rs;
        }

        private void copyfields(SimpleResultSet rs, String selectQuery) throws SQLException {
            Statement st = null;
            ResultSet rsQuery = null;
            st = this.connection.createStatement();
            try {
                rsQuery = st.executeQuery(this.limitQuery(selectQuery.toUpperCase()));
                ResultSetMetaData metadata = rsQuery.getMetaData();
                this.columnCount = metadata.getColumnCount();
                for (int i = 1; i <= this.columnCount; ++i) {
                    if (metadata.getColumnTypeName(i).equalsIgnoreCase("geometry") && this.spatialFieldIndex == -1) {
                        this.spatialFieldIndex = i;
                    }
                    rs.addColumn(metadata.getColumnName(i), metadata.getColumnType(i), metadata.getColumnTypeName(i), metadata.getPrecision(i), metadata.getScale(i));
                }
            }
            catch (SQLException ex) {
                throw new SQLException(ex);
            }
            if (this.spatialFieldIndex == -1) {
                throw new SQLException("The select query " + selectQuery + " does not contain a geometry field");
            }
        }

        private String limitQuery(String selectQuery) {
            selectQuery = selectQuery.substring(1, selectQuery.lastIndexOf(")"));
            int findLIMIT = selectQuery.lastIndexOf("LIMIT ");
            int comma = selectQuery.lastIndexOf(";");
            selectQuery = findLIMIT == -1 ? (comma == -1 ? selectQuery + " LIMIT 0;" : selectQuery.substring(0, comma) + " LIMIT 0;") : selectQuery.substring(0, findLIMIT) + " LIMIT 0;";
            return selectQuery;
        }
    }

    public static class ExplodeResultSet
    implements SimpleRowSource {
        public boolean firstRow = true;
        public ResultSet tableQuery;
        public String tableName;
        public String spatialFieldName;
        public int spatialFieldIndex = -1;
        public int columnCount;
        public Queue<Geometry> sourceRowGeometries = new LinkedList<Geometry>();
        public int explodeId = 1;
        public Connection connection;

        public ExplodeResultSet(Connection connection, String tableName, String spatialFieldName) {
            this.tableName = tableName;
            this.spatialFieldName = spatialFieldName;
            this.connection = connection;
        }

        public Object[] readRow() throws SQLException {
            if (this.firstRow) {
                this.reset();
            }
            if (this.sourceRowGeometries.isEmpty()) {
                this.parseRow();
            }
            if (this.sourceRowGeometries.isEmpty()) {
                return null;
            }
            Object[] objects = new Object[this.columnCount + 1];
            for (int i = 1; i <= this.columnCount + 1; ++i) {
                objects[i - 1] = i == this.spatialFieldIndex ? this.sourceRowGeometries.remove() : (i == this.columnCount + 1 ? Integer.valueOf(this.explodeId++) : this.tableQuery.getObject(i));
            }
            return objects;
        }

        private void explode(Geometry geometry) {
            if (geometry instanceof GeometryCollection) {
                int nbOfGeometries = geometry.getNumGeometries();
                for (int i = 0; i < nbOfGeometries; ++i) {
                    this.explode(geometry.getGeometryN(i));
                }
            } else {
                this.sourceRowGeometries.add(geometry);
            }
        }

        public void close() {
            if (this.tableQuery != null) {
                try {
                    this.tableQuery.close();
                    this.tableQuery = null;
                }
                catch (SQLException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }

        private void parseRow() throws SQLException {
            this.sourceRowGeometries.clear();
            this.explodeId = 1;
            if (this.tableQuery.next()) {
                Geometry geometry = (Geometry)this.tableQuery.getObject(this.spatialFieldIndex);
                this.explode(geometry);
                if (this.sourceRowGeometries.isEmpty()) {
                    GeometryFactory factory = geometry.getFactory();
                    if (factory == null) {
                        factory = new GeometryFactory();
                    }
                    if (geometry instanceof MultiLineString) {
                        this.sourceRowGeometries.add((Geometry)factory.createLineString(new Coordinate[0]));
                    } else if (geometry instanceof MultiPolygon) {
                        this.sourceRowGeometries.add((Geometry)factory.createPolygon(null, null));
                    } else {
                        this.sourceRowGeometries.add(null);
                    }
                }
            }
        }

        public void reset() throws SQLException {
            if (this.tableQuery != null && !this.tableQuery.isClosed()) {
                this.close();
            }
            Statement st = this.connection.createStatement();
            this.tableQuery = st.executeQuery("SELECT * FROM " + this.tableName);
            this.firstRow = false;
            ResultSetMetaData meta = this.tableQuery.getMetaData();
            this.columnCount = meta.getColumnCount();
            if (this.spatialFieldName == null) {
                List geomFields = SFSUtilities.getGeometryFields((Connection)this.connection, (TableLocation)TableLocation.parse((String)this.tableName));
                if (!geomFields.isEmpty()) {
                    this.spatialFieldName = (String)geomFields.get(0);
                } else {
                    throw new SQLException("The table " + this.tableName + " does not contain a geometry field");
                }
            }
            for (int i = 1; i <= this.columnCount; ++i) {
                if (!meta.getColumnName(i).equalsIgnoreCase(this.spatialFieldName)) continue;
                this.spatialFieldIndex = i;
                break;
            }
            if (this.spatialFieldIndex == -1) {
                throw new SQLException("Geometry field " + this.spatialFieldName + " of table " + this.tableName + " not found");
            }
        }

        public ResultSet getResultSet() throws SQLException {
            SimpleResultSet rs = new SimpleResultSet((SimpleRowSource)this);
            TableUtilities.copyFields((Connection)this.connection, (SimpleResultSet)rs, (TableLocation)TableLocation.parse((String)this.tableName, (Boolean)JDBCUtilities.isH2DataBase((DatabaseMetaData)this.connection.getMetaData())));
            rs.addColumn(ST_Explode.EXPLODE_FIELD, 4, 10, 0);
            return rs;
        }
    }
}

