/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.topography;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Triangle;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.operation.linemerge.LineMerger;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.functions.spatial.topography.TINFeatureFactory;
import org.h2gis.utilities.jts_utils.TriMarkers;

public class ST_Drape
extends DeterministicScalarFunction {
    public ST_Drape() {
        this.addProperty("remarks", "This function drapes an input geometry to a set of triangles.\nNotes : The supported input geometry types are POINT, MULTIPOINT, LINESTRING, MULTILINESTRING, POLYGON and MULTIPOLYGON \nIn case of 1 or 2 dimension, the input geometry is intersected with the triangles to perform a full draping.\nIf a point lies on two triangles the z value of the first triangle is kept.");
    }

    public String getJavaStaticMethod() {
        return "drape";
    }

    public static Geometry drape(Geometry geomToDrape, Geometry triangles) throws SQLException {
        if (geomToDrape == null) {
            return null;
        }
        if (triangles == null) {
            return geomToDrape;
        }
        int nb = triangles.getNumGeometries();
        STRtree sTRtree = new STRtree();
        for (int i = 0; i < nb; ++i) {
            Geometry geom = triangles.getGeometryN(i);
            sTRtree.insert(geom.getEnvelopeInternal(), (Object)TINFeatureFactory.createTriangle(geom));
        }
        if (geomToDrape.getDimension() == 0) {
            return ST_Drape.drapePoints(geomToDrape, triangles, sTRtree);
        }
        if (geomToDrape instanceof MultiLineString) {
            return ST_Drape.drapeMultiLineString((MultiLineString)geomToDrape, triangles, sTRtree);
        }
        if (geomToDrape instanceof MultiPolygon) {
            return ST_Drape.drapeMultiPolygon((MultiPolygon)geomToDrape, triangles, sTRtree);
        }
        if (geomToDrape instanceof Polygon) {
            return ST_Drape.drapePolygon((Polygon)geomToDrape, triangles, sTRtree);
        }
        if (geomToDrape instanceof LineString) {
            return ST_Drape.drapeLineString((LineString)geomToDrape, triangles, sTRtree);
        }
        throw new SQLException("Drape " + geomToDrape.getGeometryType() + " is not supported.");
    }

    public static Geometry drapePoints(Geometry pts, Geometry triangles, STRtree sTRtree) {
        Geometry geomDrapped = (Geometry)pts.clone();
        DrapeFilter drapeFilter = new DrapeFilter(sTRtree);
        geomDrapped.apply((CoordinateSequenceFilter)drapeFilter);
        return geomDrapped;
    }

    public static Geometry drapeMultiPolygon(MultiPolygon polygons, Geometry triangles, STRtree sTRtree) {
        GeometryFactory factory = polygons.getFactory();
        Geometry triangleLines = LinearComponentExtracter.getGeometry((Geometry)triangles, (boolean)true);
        int nbPolygons = polygons.getNumGeometries();
        Polygon[] polygonsDiff = new Polygon[nbPolygons];
        for (int i = 0; i < nbPolygons; ++i) {
            polygonsDiff[i] = ST_Drape.processPolygon((Polygon)polygons.getGeometryN(i), triangleLines, factory);
        }
        MultiPolygon diffExt = factory.createMultiPolygon(polygonsDiff);
        DrapeFilter drapeFilter = new DrapeFilter(sTRtree);
        diffExt.apply((CoordinateSequenceFilter)drapeFilter);
        return diffExt;
    }

    public static Geometry drapeMultiLineString(MultiLineString lines, Geometry triangles, STRtree sTRtree) {
        GeometryFactory factory = lines.getFactory();
        Geometry triangleLines = LinearComponentExtracter.getGeometry((Geometry)triangles, (boolean)true);
        int nbLines = lines.getNumGeometries();
        LineString[] lineStrings = new LineString[nbLines];
        for (int i = 0; i < nbLines; ++i) {
            lineStrings[i] = (LineString)ST_Drape.lineMerge(lines.getGeometryN(i).difference(triangleLines), factory);
        }
        MultiLineString diffExt = factory.createMultiLineString(lineStrings);
        DrapeFilter drapeFilter = new DrapeFilter(sTRtree);
        diffExt.apply((CoordinateSequenceFilter)drapeFilter);
        return diffExt;
    }

    public static Geometry drapeLineString(LineString line, Geometry triangles, STRtree sTRtree) {
        GeometryFactory factory = line.getFactory();
        Geometry triangleLines = LinearComponentExtracter.getGeometry((Geometry)triangles, (boolean)true);
        Geometry diffExt = ST_Drape.lineMerge(line.difference(triangleLines), factory);
        DrapeFilter drapeFilter = new DrapeFilter(sTRtree);
        diffExt.apply((CoordinateSequenceFilter)drapeFilter);
        return diffExt;
    }

    public static Geometry drapePolygon(Polygon p, Geometry triangles, STRtree sTRtree) {
        GeometryFactory factory = p.getFactory();
        Geometry triangleLines = LinearComponentExtracter.getGeometry((Geometry)triangles, (boolean)true);
        Polygon splittedP = ST_Drape.processPolygon(p, triangleLines, factory);
        DrapeFilter drapeFilter = new DrapeFilter(sTRtree);
        splittedP.apply((CoordinateSequenceFilter)drapeFilter);
        return splittedP;
    }

    private static Polygon processPolygon(Polygon p, Geometry triangleLines, GeometryFactory factory) {
        Geometry diffExt = p.getExteriorRing().difference(triangleLines);
        int nbOfHoles = p.getNumInteriorRing();
        LinearRing[] holes = new LinearRing[nbOfHoles];
        for (int i = 0; i < nbOfHoles; ++i) {
            holes[i] = factory.createLinearRing(ST_Drape.lineMerge(p.getInteriorRingN(i).difference(triangleLines), factory).getCoordinates());
        }
        return factory.createPolygon(factory.createLinearRing(ST_Drape.lineMerge(diffExt, factory).getCoordinates()), holes);
    }

    public static Geometry lineMerge(Geometry geom, GeometryFactory factory) {
        LineMerger merger = new LineMerger();
        merger.add(geom);
        Collection lines = merger.getMergedLineStrings();
        return factory.buildGeometry(lines);
    }

    private static class DrapeFilter
    implements CoordinateSequenceFilter {
        private boolean done = false;
        private final STRtree q;

        public DrapeFilter(STRtree q) {
            this.q = q;
        }

        public void filter(CoordinateSequence seq, int i) {
            Coordinate coord = seq.getCoordinate(i);
            List result = this.q.query(new Envelope(coord));
            if (!result.isEmpty()) {
                double z = Double.NaN;
                for (Triangle triangle : result) {
                    if (!TriMarkers.intersects((Coordinate)coord, (Triangle)triangle)) continue;
                    z = triangle.interpolateZ(coord);
                    break;
                }
                seq.setOrdinate(i, 2, z);
            }
            if (i == seq.size()) {
                this.done = true;
            }
        }

        public boolean isDone() {
            return this.done;
        }

        public boolean isGeometryChanged() {
            return true;
        }
    }
}

