/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.topography;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Triangle;
import com.vividsolutions.jts.math.Vector3D;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.functions.spatial.topography.TINFeatureFactory;
import org.h2gis.utilities.jts_utils.TriMarkers;

public class ST_TriangleSlope
extends DeterministicScalarFunction {
    public ST_TriangleSlope() {
        this.addProperty("remarks", "Compute the slope of a triangle expressed in percents.");
    }

    public String getJavaStaticMethod() {
        return "computeSlope";
    }

    public static Double computeSlope(Geometry geometry) throws IllegalArgumentException {
        if (geometry == null) {
            return null;
        }
        return TriMarkers.getSlopeInPercent((Vector3D)TriMarkers.getNormalVector((Triangle)TINFeatureFactory.createTriangle(geometry)), (double)1.0E-12);
    }
}

