/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.drivers.utility;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;

public final class CoordinatesUtils {
    public static double interpolate(Coordinate firstCoordinate, Coordinate lastCoordinate, Coordinate toBeInterpolated) {
        if (Double.isNaN(firstCoordinate.z)) {
            return Double.NaN;
        }
        if (Double.isNaN(lastCoordinate.z)) {
            return Double.NaN;
        }
        return firstCoordinate.z + (lastCoordinate.z - firstCoordinate.z) * firstCoordinate.distance(toBeInterpolated) / (firstCoordinate.distance(toBeInterpolated) + toBeInterpolated.distance(lastCoordinate));
    }

    public static boolean contains(Coordinate[] coords, Coordinate coord) {
        int n = 0;
        Coordinate[] coordinateArray = coords;
        int n2 = coordinateArray.length;
        if (n < n2) {
            Coordinate coordinate = coordinateArray[n];
            if (Double.isNaN(coord.z)) {
                return coordinate.equals((Object)coord);
            }
            return coordinate.equals3D(coord);
        }
        return false;
    }

    public static boolean contains2D(Coordinate[] coords, Coordinate coord) {
        for (Coordinate coordinate : coords) {
            if (!coordinate.equals2D(coord)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains3D(Coordinate[] coords, Coordinate coord) {
        for (Coordinate coordinate : coords) {
            if (!coordinate.equals3D(coord)) continue;
            return true;
        }
        return false;
    }

    public static double[] zMinMax(Coordinate[] cs) {
        boolean validZFound = false;
        double[] result = new double[2];
        double zmin = Double.NaN;
        double zmax = Double.NaN;
        for (int t = cs.length - 1; t >= 0; --t) {
            double z = cs[t].z;
            if (Double.isNaN(z)) continue;
            if (validZFound) {
                if (z < zmin) {
                    zmin = z;
                }
                if (!(z > zmax)) continue;
                zmax = z;
                continue;
            }
            validZFound = true;
            zmin = z;
            zmax = z;
        }
        result[0] = zmin;
        result[1] = zmax;
        return result;
    }

    public static Coordinate[] getFurthestCoordinate(Coordinate base, Coordinate[] coords) {
        double distanceMax = Double.MIN_VALUE;
        Coordinate farCoordinate = null;
        for (Coordinate coord : coords) {
            double distance = coord.distance(base);
            if (!(distance > distanceMax)) continue;
            distanceMax = distance;
            farCoordinate = coord;
        }
        if (farCoordinate != null) {
            return new Coordinate[]{base, farCoordinate};
        }
        return null;
    }

    public static double length3D(CoordinateSequence pts) {
        int n = pts.size();
        if (n <= 1) {
            return 0.0;
        }
        double len = 0.0;
        Coordinate p = new Coordinate();
        pts.getCoordinate(0, p);
        double x0 = p.x;
        double y0 = p.y;
        double z0 = p.z;
        if (Double.isNaN(z0)) {
            return 0.0;
        }
        for (int i = 1; i < n; ++i) {
            pts.getCoordinate(i, p);
            double x1 = p.x;
            double y1 = p.y;
            double z1 = p.z;
            if (Double.isNaN(z1)) {
                return 0.0;
            }
            double dx = x1 - x0;
            double dy = y1 - y0;
            double dz = z1 - z0;
            len += Math.sqrt(dx * dx + dy * dy + dz * dz);
            x0 = x1;
            y0 = y1;
            z0 = z1;
        }
        return len;
    }

    public static double length3D(Geometry geom) {
        double sum = 0.0;
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry subGeom = geom.getGeometryN(i);
            if (subGeom instanceof Polygon) {
                sum += CoordinatesUtils.length3D((Polygon)subGeom);
                continue;
            }
            if (!(subGeom instanceof LineString)) continue;
            sum += CoordinatesUtils.length3D((LineString)subGeom);
        }
        return sum;
    }

    public static double length3D(LineString lineString) {
        return CoordinatesUtils.length3D(lineString.getCoordinateSequence());
    }

    public static double length3D(Polygon polygon) {
        double len = 0.0;
        len += CoordinatesUtils.length3D(polygon.getExteriorRing().getCoordinateSequence());
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            len += CoordinatesUtils.length3D(polygon.getInteriorRingN(i));
        }
        return len;
    }

    private CoordinatesUtils() {
    }
}

