/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.dbf;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2gis.api.AbstractFunction;
import org.h2gis.api.EmptyProgressVisitor;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.api.ScalarFunction;
import org.h2gis.functions.io.dbf.DBFDriverFunction;
import org.h2gis.utilities.URIUtilities;

public class DBFWrite
extends AbstractFunction
implements ScalarFunction {
    public DBFWrite() {
        this.addProperty("remarks", "Transfer the content of a table into a DBF\nCALL DBFWRITE('FILENAME', 'TABLE'[,'ENCODING']) or CALL DBFWRITE('FILENAME', '(SELECT * FROM TABLE)'[,'ENCODING'])");
    }

    public String getJavaStaticMethod() {
        return "exportTable";
    }

    public static void exportTable(Connection connection, String fileName, String tableReference) throws IOException, SQLException {
        DBFDriverFunction driverFunction = new DBFDriverFunction();
        driverFunction.exportTable(connection, tableReference, URIUtilities.fileFromString((String)fileName), (ProgressVisitor)new EmptyProgressVisitor());
    }

    public static void exportTable(Connection connection, String fileName, String tableReference, String encoding) throws IOException, SQLException {
        DBFDriverFunction driverFunction = new DBFDriverFunction();
        driverFunction.exportTable(connection, tableReference, new File(fileName), (ProgressVisitor)new EmptyProgressVisitor(), encoding);
    }
}

