/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.distance;

import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.functions.spatial.distance.MaxDistanceOp;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;

public class ST_LongestLine
extends DeterministicScalarFunction {
    public ST_LongestLine() {
        this.addProperty("remarks", "Returns the 2-dimensional longest line between the points of two geometries.If the geometry 1 and geometry 2 is the same geometry the function will \n return the longest line between the two vertices most far from each other in that geometry.");
    }

    public String getJavaStaticMethod() {
        return "longestLine";
    }

    public static Geometry longestLine(Geometry geomA, Geometry geomB) {
        Coordinate[] coords = new MaxDistanceOp(geomA, geomB).getCoordinatesDistance();
        if (coords != null) {
            return geomA.getFactory().createLineString(coords);
        }
        return null;
    }
}

