/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.distance;

import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.operation.distance.DistanceOp;

public class ST_ShortestLine
extends DeterministicScalarFunction {
    public ST_ShortestLine() {
        this.addProperty("remarks", "Returns the 2-dimensional shortest line between two geometries. \nThe function will only return the first shortest line if more than one, that the function finds.");
    }

    public String getJavaStaticMethod() {
        return "shortestLine";
    }

    public static LineString shortestLine(Geometry geomA, Geometry geomB) {
        if (geomA == null || geomB == null) {
            return null;
        }
        if (geomA.isEmpty() || geomB.isEmpty()) {
            return null;
        }
        Coordinate[] pts = DistanceOp.nearestPoints((Geometry)geomA, (Geometry)geomB);
        return geomA.getFactory().createLineString(pts);
    }
}

