/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.utility;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.h2gis.api.DriverFunction;
import org.h2gis.api.EmptyProgressVisitor;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.functions.io.asc.AscDriverFunction;
import org.h2gis.functions.io.csv.CSVDriverFunction;
import org.h2gis.functions.io.dbf.DBFDriverFunction;
import org.h2gis.functions.io.geojson.GeoJsonDriverFunction;
import org.h2gis.functions.io.gpx.GPXDriverFunction;
import org.h2gis.functions.io.json.JsonDriverFunction;
import org.h2gis.functions.io.kml.KMLDriverFunction;
import org.h2gis.functions.io.osm.OSMDriverFunction;
import org.h2gis.functions.io.shp.SHPDriverFunction;
import org.h2gis.functions.io.tsv.TSVDriverFunction;
import org.h2gis.utilities.FileUtilities;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.URIUtilities;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.h2gis.utilities.dbtypes.DBUtils;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOMethods {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOMethods.class);
    private static final String ENCODING_OPTION = "charset=";
    private static final String UTF_ENCODING = "UTF-8";
    private List<DriverFunction> driverFunctionList = new ArrayList<DriverFunction>();

    public IOMethods() {
        this.driverFunctionList.add(new CSVDriverFunction());
        this.driverFunctionList.add(new DBFDriverFunction());
        this.driverFunctionList.add(new GeoJsonDriverFunction());
        this.driverFunctionList.add(new GPXDriverFunction());
        this.driverFunctionList.add(new JsonDriverFunction());
        this.driverFunctionList.add(new KMLDriverFunction());
        this.driverFunctionList.add(new OSMDriverFunction());
        this.driverFunctionList.add(new SHPDriverFunction());
        this.driverFunctionList.add(new TSVDriverFunction());
        this.driverFunctionList.add(new AscDriverFunction());
    }

    public static String linkedTable(Connection targetConnection, Properties properties, String sourceTable, String targetTable, boolean delete) throws SQLException {
        HashMap<String, String> map = new HashMap<String, String>();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> map.put(key.toString(), value.toString())));
        return IOMethods.linkedTable(targetConnection, map, sourceTable, targetTable, delete);
    }

    public static String linkedTable(Connection targetConnection, Properties properties, String sourceTable, String targetTable, boolean delete, int fetchSize) throws SQLException {
        HashMap<String, String> map = new HashMap<String, String>();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> map.put(key.toString(), value.toString())));
        return IOMethods.linkedTable(targetConnection, map, sourceTable, targetTable, delete, fetchSize);
    }

    public static String linkedTable(Connection targetConnection, Map<String, String> databaseProperties, String sourceTable, String targetTable, boolean delete) throws SQLException {
        return IOMethods.linkedTable(targetConnection, databaseProperties, sourceTable, targetTable, delete, 100);
    }

    public static String linkedTable(Connection targetConnection, Map<String, String> databaseProperties, String sourceTable, String targetTable, boolean delete, int fetchSize) throws SQLException {
        if (targetConnection == null) {
            throw new SQLException("The connection to the output database cannot be null.\n");
        }
        if (sourceTable == null || sourceTable.isEmpty()) {
            throw new SQLException("The source table cannot be null or empty.\n");
        }
        if (targetTable == null || targetTable.isEmpty()) {
            throw new SQLException("The target table cannot be null or empty.\n");
        }
        if (databaseProperties == null || databaseProperties.isEmpty()) {
            throw new SQLException("The external database connection properties cannot be null or empty.\n");
        }
        DBTypes targetDBType = DBUtils.getDBType((Connection)targetConnection);
        if (targetDBType != DBTypes.H2 && targetDBType != DBTypes.H2GIS) {
            throw new SQLException("Link file is only supported with an H2GIS database");
        }
        String user = databaseProperties.getOrDefault("user", "sa");
        String password = databaseProperties.getOrDefault("password", "");
        String driverName = "";
        Object jdbc_url = databaseProperties.get("url");
        String autocommit_linkedTable = "";
        if (jdbc_url != null) {
            if (((String)jdbc_url).startsWith("jdbc:")) {
                String url = ((String)jdbc_url).substring("jdbc:".length());
                if (url.startsWith("h2")) {
                    driverName = "org.h2.Driver";
                } else if (url.startsWith("postgresql_h2")) {
                    driverName = "org.h2gis.postgis_jts.Driver";
                    autocommit_linkedTable = "AUTOCOMMIT OFF";
                } else if (url.startsWith("postgresql")) {
                    autocommit_linkedTable = "AUTOCOMMIT OFF";
                    driverName = "org.h2gis.postgis_jts.Driver";
                    jdbc_url = "jdbc:postgresql_h2" + ((String)jdbc_url).substring("jdbc:postgresql".length());
                }
                if (!driverName.isEmpty()) {
                    TableLocation targetTableLocation = TableLocation.parse((String)targetTable, (DBTypes)targetDBType);
                    String ouputTableName = targetTableLocation.toString(targetDBType);
                    if (delete) {
                        try (Statement stmt = targetConnection.createStatement();){
                            stmt.execute("DROP TABLE IF EXISTS " + ouputTableName);
                            if (!targetConnection.getAutoCommit()) {
                                targetConnection.commit();
                            }
                        }
                        catch (SQLException e) {
                            try {
                                targetConnection.rollback();
                            }
                            catch (SQLException e1) {
                                throw new SQLException("Unable to rollback.", e1);
                            }
                            throw new SQLException("Cannot drop the table", e);
                        }
                    }
                    try (Statement statement = targetConnection.createStatement();){
                        statement.execute(String.format("CREATE LINKED TABLE %s('%s', '%s', '%s', '%s', '%s') FETCH_SIZE %s %s", ouputTableName, driverName, jdbc_url, user, password, sourceTable, fetchSize, autocommit_linkedTable));
                        if (!targetConnection.getAutoCommit()) {
                            targetConnection.commit();
                        }
                    }
                    catch (SQLException e) {
                        try {
                            targetConnection.rollback();
                        }
                        catch (SQLException e1) {
                            throw new SQLException("Unable to rollback.", e1);
                        }
                        throw new SQLException("Cannot linked the table", e);
                    }
                    return ouputTableName;
                }
                throw new SQLException("This database is not yet supported");
            }
            throw new SQLException("JDBC URL must start with jdbc:");
        }
        throw new SQLException("The URL of the external database cannot be null");
    }

    public static String linkedFile(Connection connection, String filePath, String tableName, boolean delete) throws SQLException {
        Statement statement;
        DBTypes dbType = DBUtils.getDBType((Connection)connection);
        if (dbType != DBTypes.H2 && dbType != DBTypes.H2GIS) {
            throw new SQLException("Link file is only supported with an H2GIS database");
        }
        if (filePath == null || filePath.isEmpty()) {
            throw new SQLException("The path to the file cannot be null or empty");
        }
        if (tableName == null || tableName.isEmpty()) {
            throw new SQLException("The name of the table cannot be null or empty");
        }
        if (delete) {
            try {
                statement = connection.createStatement();
                try {
                    statement.execute("DROP TABLE IF EXISTS " + tableName);
                    if (!connection.getAutoCommit()) {
                        connection.commit();
                    }
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            catch (SQLException e) {
                try {
                    connection.rollback();
                }
                catch (SQLException e1) {
                    throw new SQLException("Unable to rollback.", e1);
                }
                throw new SQLException("Cannot drop the table", e);
            }
        }
        try {
            statement = connection.createStatement();
            try {
                statement.execute(String.format("CALL FILE_TABLE('%s','%s')", filePath, tableName));
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException e1) {
                throw new SQLException("Unable to rollback.", e1);
            }
            throw new SQLException("Cannot link the file", e);
        }
        return tableName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String exportToDataBase(Connection sourceConnection, String sourceTable, Connection targetConnection, String targetTable, int mode, int batch_size) throws SQLException {
        Object query;
        if (sourceConnection == null) {
            throw new SQLException("The connection to the source database cannot be null.\n");
        }
        if (targetConnection == null) {
            throw new SQLException("The connection to the output database cannot be null.\n");
        }
        if (-2 > mode && mode > 2) {
            throw new SQLException("Supported mode to export the table is : \n-1 delete the target table if exists and create a new table, \n0 create a new table\n1 update the target table if exists");
        }
        if (batch_size <= 0) {
            throw new SQLException("The batch size must be greater than 0.\n");
        }
        if (sourceTable == null || sourceTable.isEmpty()) {
            throw new SQLException("The source table cannot be null or empty.\n");
        }
        if (targetTable == null || targetTable.isEmpty()) {
            throw new SQLException("The target table cannot be null or empty.\n");
        }
        DBTypes sourceDBType = DBUtils.getDBType((Connection)sourceConnection);
        DBTypes targetDBType = DBUtils.getDBType((Connection)targetConnection);
        TableLocation targetTableLocation = TableLocation.parse((String)targetTable, (DBTypes)targetDBType);
        String ouputTableName = targetTableLocation.toString(targetDBType);
        String regex = ".*(?i)\\b(select|from)\\b.*";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(sourceTable);
        if (matcher.find()) {
            if (!sourceTable.startsWith("(") || !sourceTable.endsWith(")")) throw new SQLException("The select query must be enclosed in parenthesis: '(SELECT * FROM MYTATBLE)'.");
            query = sourceTable;
        } else {
            TableLocation sourceTableLocation = TableLocation.parse((String)sourceTable, (DBTypes)sourceDBType);
            if (!JDBCUtilities.tableExists((Connection)sourceConnection, (TableLocation)sourceTableLocation)) {
                throw new SQLException("The source table doesn't exist.\n");
            }
            query = "SELECT * FROM " + sourceTableLocation.toString(sourceDBType);
        }
        try {
            ResultSetMetaData inputMetadata;
            ResultSet inputRes;
            block76: {
                Statement outputST;
                String ddlCommand;
                Statement inputStat = sourceConnection.createStatement();
                inputRes = inputStat.executeQuery((String)query);
                inputMetadata = inputRes.getMetaData();
                targetConnection.setAutoCommit(false);
                if (mode == -1) {
                    try (Statement stmt = targetConnection.createStatement();){
                        stmt.execute("DROP TABLE IF EXISTS " + ouputTableName);
                        targetConnection.commit();
                    }
                    catch (SQLException e) {
                        try {
                            targetConnection.rollback();
                            throw new SQLException("Cannot drop the table", e);
                        }
                        catch (SQLException e1) {
                            throw new SQLException("Unable to rollback.", e1);
                        }
                    }
                    ddlCommand = JDBCUtilities.createTableDDL((ResultSetMetaData)inputMetadata, (String)ouputTableName);
                    if (!ddlCommand.isEmpty()) {
                        try {
                            outputST = targetConnection.createStatement();
                            try {
                                outputST.execute(ddlCommand);
                                targetConnection.commit();
                            }
                            finally {
                                if (outputST != null) {
                                    outputST.close();
                                }
                            }
                        }
                        catch (SQLException e) {
                            try {
                                targetConnection.rollback();
                                throw new SQLException("Cannot create the output table", e);
                            }
                            catch (SQLException e1) {
                                throw new SQLException("Unable to rollback.", e1);
                            }
                        }
                    }
                } else if (mode == 0) {
                    if (JDBCUtilities.tableExists((Connection)targetConnection, (TableLocation)targetTableLocation)) {
                        throw new SQLException("The target table already exists.\nPlease use a -1 (delete) or 2 (insert) mode to export the table");
                    }
                    ddlCommand = JDBCUtilities.createTableDDL((ResultSetMetaData)inputMetadata, (String)ouputTableName);
                    if (!ddlCommand.isEmpty()) {
                        try {
                            outputST = targetConnection.createStatement();
                            try {
                                outputST.execute(ddlCommand);
                                targetConnection.commit();
                                break block76;
                            }
                            finally {
                                if (outputST != null) {
                                    outputST.close();
                                }
                            }
                        }
                        catch (SQLException e) {
                            try {
                                targetConnection.rollback();
                                throw new SQLException("Cannot create the output table", e);
                            }
                            catch (SQLException e1) {
                                LOGGER.error("Unable to rollback.", (Throwable)e1);
                            }
                            throw new SQLException("Cannot create the output table", e);
                        }
                    }
                    if (mode == 1 && !JDBCUtilities.tableExists((Connection)targetConnection, (TableLocation)targetTableLocation)) {
                        throw new SQLException("The target table doesn't exist.\nPlease use a 0 mode to create a new table and populate it");
                    }
                }
            }
            Statement preparedStatement = null;
            try {
                int i;
                targetConnection.setAutoCommit(false);
                int columnsCount = inputMetadata.getColumnCount();
                HashMap<String, Integer> geomColumnAndSRID = new HashMap<String, Integer>();
                StringBuilder insertTable = new StringBuilder("INSERT INTO ");
                insertTable.append(ouputTableName).append(" VALUES(?");
                for (i = 1; i < columnsCount; ++i) {
                    insertTable.append(",").append("?");
                }
                insertTable.append(")");
                if (!inputRes.next()) return ouputTableName;
                preparedStatement = targetConnection.prepareStatement(insertTable.toString());
                for (i = 0; i < columnsCount; ++i) {
                    int index = i + 1;
                    Object value = inputRes.getObject(index);
                    if (inputMetadata.getColumnTypeName(index).toLowerCase().startsWith("geometry")) {
                        geomColumnAndSRID.put(inputMetadata.getColumnName(index), ((Geometry)value).getSRID());
                    }
                    preparedStatement.setObject(index, value);
                }
                preparedStatement.execute();
                long batchSize = 0L;
                while (inputRes.next()) {
                    for (int i2 = 0; i2 < columnsCount; ++i2) {
                        int index = i2 + 1;
                        Object value = inputRes.getObject(index);
                        String columnName = inputMetadata.getColumnName(index);
                        if (geomColumnAndSRID.containsKey(columnName)) {
                            Geometry geometry = (Geometry)value;
                            int currentSRID = geometry.getSRID();
                            Integer tmpSRID = (Integer)geomColumnAndSRID.get(columnName);
                            if (tmpSRID != currentSRID) {
                                geomColumnAndSRID.remove(inputMetadata.getColumnName(index));
                            }
                        }
                        preparedStatement.setObject(index, value);
                    }
                    preparedStatement.addBatch();
                    if (++batchSize < (long)batch_size) continue;
                    preparedStatement.executeBatch();
                    targetConnection.commit();
                    preparedStatement.clearBatch();
                    batchSize = 0L;
                }
                if (batchSize > 0L) {
                    preparedStatement.executeBatch();
                    targetConnection.commit();
                }
                if (geomColumnAndSRID.isEmpty()) return ouputTableName;
                StringBuilder querySRID = new StringBuilder();
                for (Map.Entry entry : geomColumnAndSRID.entrySet()) {
                    String fieldName = TableLocation.capsIdentifier((String)((String)entry.getKey()), (DBTypes)targetDBType);
                    Integer srid = (Integer)entry.getValue();
                    querySRID.append("ALTER TABLE ").append(ouputTableName).append(" ALTER COLUMN ").append(fieldName);
                    querySRID.append(" TYPE GEOMETRY(GEOMETRY, ").append(srid).append(") USING ST_SetSRID(").append(fieldName).append(",").append(srid).append(");\n");
                }
                try (Statement outputST = targetConnection.createStatement();){
                    outputST.execute(querySRID.toString());
                    targetConnection.commit();
                    return ouputTableName;
                }
                catch (SQLException e) {
                    try {
                        targetConnection.rollback();
                        throw new SQLException("Cannot alter the table with the SRID", e);
                    }
                    catch (SQLException e1) {
                        LOGGER.error("Unable to rollback.", (Throwable)e1);
                    }
                    throw new SQLException("Cannot alter the table with the SRID", e);
                }
            }
            catch (SQLException e) {
                try {
                    targetConnection.rollback();
                    throw new SQLException("Cannot insert the data in the table", e);
                }
                catch (SQLException e1) {
                    LOGGER.error("Unable to rollback.", (Throwable)e1);
                }
                throw new SQLException("Cannot insert the data in the table", e);
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                targetConnection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            throw new SQLException("Cannot save the table " + sourceTable + " to the " + targetTable + "\n", e);
        }
    }

    public List<DriverFunction> getDriverFunctionList() {
        return Collections.unmodifiableList(this.driverFunctionList);
    }

    public void addDriver(DriverFunction driver) {
        this.driverFunctionList.add(driver);
    }

    public void removeDriver(DriverFunction driver) {
        this.driverFunctionList.remove(driver);
    }

    public List<String> getAllExportDriverSupportedExtensions() {
        ArrayList<String> extensions = new ArrayList<String>();
        for (DriverFunction f : this.driverFunctionList) {
            extensions.addAll(Arrays.asList(f.getExportFormats()));
        }
        return extensions;
    }

    public List<String> getAllImportDriverSupportedExtensions() {
        ArrayList<String> extensions = new ArrayList<String>();
        for (DriverFunction f : this.driverFunctionList) {
            extensions.addAll(Arrays.asList(f.getImportFormats()));
        }
        return extensions;
    }

    public DriverFunction getExportDriverFromFile(File file) {
        String path = file.getAbsolutePath();
        for (DriverFunction f : this.driverFunctionList) {
            for (String ext : f.getExportFormats()) {
                if (!path.toLowerCase().endsWith("." + ext)) continue;
                return f;
            }
        }
        LOGGER.error("Unsupported file format.\nSupported formats are : [" + String.join((CharSequence)",", this.getAllExportDriverSupportedExtensions()) + "].");
        return null;
    }

    public DriverFunction getImportDriverFromFile(File file) {
        String path = file.getAbsolutePath();
        for (DriverFunction f : this.driverFunctionList) {
            for (String ext : f.getImportFormats()) {
                if (!path.toLowerCase().endsWith(ext)) continue;
                return f;
            }
        }
        LOGGER.error("Unsupported file format.\nSupported formats are : [" + String.join((CharSequence)",", this.getAllImportDriverSupportedExtensions()) + "].");
        return null;
    }

    public String[] exportToFile(Connection connection, String tableName, String filePath, String encoding, boolean deleteFile) throws SQLException {
        String enc = encoding;
        File fileToSave = URIUtilities.fileFromString((String)filePath);
        DriverFunction driverFunction = this.getExportDriverFromFile(fileToSave);
        if (driverFunction == null) {
            throw new SQLException("Cannot find any file driver for the file." + filePath);
        }
        try {
            if (FileUtilities.isExtensionWellFormated((File)fileToSave, (String)"csv") && enc == null) {
                enc = "charset=UTF-8";
            }
            return driverFunction.exportTable(connection, tableName, fileToSave, enc, deleteFile, (ProgressVisitor)new EmptyProgressVisitor());
        }
        catch (IOException | SQLException e) {
            throw new SQLException("Cannot save the table.\n", e);
        }
    }

    public String[] importFile(Connection connection, String filePath, String tableName, String encoding, boolean deleteTable) throws SQLException {
        File fileToImport = URIUtilities.fileFromString((String)filePath);
        DriverFunction driverFunction = this.getImportDriverFromFile(fileToImport);
        if (driverFunction == null) {
            throw new SQLException("Cannot find any file driver for the file." + filePath);
        }
        try {
            return driverFunction.importFile(connection, tableName, fileToImport, encoding, deleteTable, (ProgressVisitor)new EmptyProgressVisitor());
        }
        catch (IOException | SQLException e) {
            throw new SQLException("Cannot import the file.", e);
        }
    }
}

