/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.buffer;

import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.operation.buffer.VariableBuffer;

public class ST_VariableBuffer
extends DeterministicScalarFunction {
    public ST_VariableBuffer() {
        this.addProperty("remarks", "Create a buffer polygon along a line with the buffer distance interpolated\n between a start distance and an end distance.");
    }

    public String getJavaStaticMethod() {
        return "buffer";
    }

    public static Geometry buffer(Geometry geom, Double startDistance, Double endDistance) throws SQLException {
        if (geom == null || startDistance == null || endDistance == null) {
            return null;
        }
        if (geom instanceof LineString) {
            return VariableBuffer.buffer((Geometry)geom, (double)startDistance, (double)endDistance);
        }
        throw new SQLException("ST_VariableBuffer supports only LineString");
    }
}

