/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.crs;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSpatialRef {
    public static String USER_SPATIAL_REF_SYS_TABLE = "USER_SPATIAL_REF_SYS";
    static String USER_SPATIAL_REF_SYS_SEQUENCE = "USER_SPATIAL_REF_SYS_SEQ";
    private static Connection con;
    private static final Logger LOGGER;

    public static void createUserSpatialRefTable(Connection con) throws SQLException {
        try (Statement st = con.createStatement();){
            st.execute("CREATE SEQUENCE IF NOT EXISTS " + USER_SPATIAL_REF_SYS_SEQUENCE + " AS INTEGER START WITH 1000000;CREATE LOCAL TEMPORARY TABLE IF NOT EXISTS " + USER_SPATIAL_REF_SYS_TABLE + " (SRID bigint primary key, SRTEXT VARCHAR);");
        }
    }

    public static int getUserSRID(String prj) {
        if (con == null) {
            LOGGER.warn("Please init the connection to the database\n,  otherwise the srid will be set to 0");
            return 0;
        }
        int generateSrid = 0;
        try (Statement st = con.createStatement();){
            PreparedStatement prep = con.prepareStatement("INSERT INTO " + USER_SPATIAL_REF_SYS_TABLE + "(SRID, SRTEXT) VALUES (next value for " + USER_SPATIAL_REF_SYS_SEQUENCE + ", ?)", 1);
            prep.setString(1, prj);
            prep.execute();
            ResultSet rs = prep.getGeneratedKeys();
            if (rs.next()) {
                generateSrid = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return generateSrid;
    }

    public static void init(Connection connection) throws SQLException {
        con = connection;
        UserSpatialRef.createUserSpatialRefTable(connection);
    }

    static {
        LOGGER = LoggerFactory.getLogger(UserSpatialRef.class);
    }
}

