/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.h2.tools.Csv;
import org.h2gis.api.DriverFunction;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.functions.io.DriverManager;
import org.h2gis.utilities.FileUtilities;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.h2gis.utilities.dbtypes.DBUtils;

public class CSVDriverFunction
implements DriverFunction {
    public static String DESCRIPTION = "CSV file (Comma Separated Values)";
    private static final int BATCH_MAX_SIZE = 100;
    private static final int AVERAGE_NODE_SIZE = 500;

    public DriverFunction.IMPORT_DRIVER_TYPE getImportDriverType() {
        return DriverFunction.IMPORT_DRIVER_TYPE.COPY;
    }

    public String[] getImportFormats() {
        return new String[]{"csv"};
    }

    public String[] getExportFormats() {
        return new String[]{"csv"};
    }

    public String getFormatDescription(String format) {
        if (format.equalsIgnoreCase("csv")) {
            return DESCRIPTION;
        }
        return "";
    }

    public boolean isSpatialFormat(String extension) {
        return false;
    }

    public String[] exportTable(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        return this.exportTable(connection, tableReference, fileName, null, false, progress);
    }

    public String[] exportTable(Connection connection, String tableReference, File fileName, boolean deleteFiles, ProgressVisitor progress) throws SQLException, IOException {
        return this.exportTable(connection, tableReference, fileName, null, deleteFiles, progress);
    }

    public String[] exportTable(Connection connection, String tableReference, File fileName, String csvOptions, boolean deleteFiles, ProgressVisitor progress) throws SQLException, IOException {
        progress = DriverManager.check(connection, tableReference, fileName, progress);
        if (!FileUtilities.isExtensionWellFormated((File)fileName, (String)"csv")) {
            throw new SQLException("Only .csv extension is supported");
        }
        if (deleteFiles) {
            Files.deleteIfExists(fileName.toPath());
        } else if (fileName.exists()) {
            throw new IOException("The CSV file already exist.");
        }
        String regex = ".*(?i)\\b(select|from)\\b.*";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(tableReference);
        if (matcher.find()) {
            if (tableReference.startsWith("(") && tableReference.endsWith(")")) {
                try (Statement st = connection.createStatement();){
                    JDBCUtilities.attachCancelResultSet((Statement)st, (ProgressVisitor)progress);
                    Csv csv = new Csv();
                    if (csvOptions != null && csvOptions.indexOf(61) >= 0) {
                        csv.setOptions(csvOptions);
                    }
                    csv.write(fileName.getPath(), st.executeQuery(tableReference), null);
                    String[] stringArray = new String[]{tableReference};
                    return stringArray;
                }
            }
            throw new SQLException("The select query must be enclosed in parenthesis: '(SELECT * FROM ORDERS)'.");
        }
        DBTypes dbType = DBUtils.getDBType((Connection)connection);
        TableLocation requestedTable = TableLocation.parse((String)tableReference, (DBTypes)dbType);
        String outputTable = requestedTable.toString();
        try (Statement st = connection.createStatement();){
            JDBCUtilities.attachCancelResultSet((Statement)st, (ProgressVisitor)progress);
            Csv csv = new Csv();
            if (csvOptions != null && csvOptions.indexOf(61) >= 0) {
                csv.setOptions(csvOptions);
            }
            csv.write(fileName.getPath(), st.executeQuery("SELECT * FROM " + outputTable), null);
            String[] stringArray = new String[]{outputTable};
            return stringArray;
        }
    }

    public String[] exportTable(Connection connection, String tableReference, File fileName, String csvOptions, ProgressVisitor progress) throws SQLException, IOException {
        return this.exportTable(connection, tableReference, fileName, csvOptions, false, progress);
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        return this.importFile(connection, tableReference, fileName, null, false, progress);
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, String csvOptions, ProgressVisitor progress) throws SQLException, IOException {
        return this.importFile(connection, tableReference, fileName, csvOptions, false, progress);
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, boolean deleteTables, ProgressVisitor progress) throws SQLException, IOException {
        return this.importFile(connection, tableReference, fileName, null, deleteTables, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] importFile(Connection connection, String tableReference, File fileName, String csvOptions, boolean deleteTables, ProgressVisitor progress) throws SQLException, IOException {
        progress = DriverManager.check(connection, tableReference, fileName, progress);
        if (FileUtilities.isFileImportable((File)fileName, (String)"csv")) {
            TableLocation requestedTable;
            DBTypes dbType = DBUtils.getDBType((Connection)connection);
            if (deleteTables) {
                requestedTable = TableLocation.parse((String)tableReference, (DBTypes)dbType);
                Statement stmt = connection.createStatement();
                stmt.execute("DROP TABLE IF EXISTS " + requestedTable);
                stmt.close();
            }
            requestedTable = TableLocation.parse((String)tableReference, (DBTypes)dbType);
            String outputTable = requestedTable.getTable();
            FileInputStream fis = new FileInputStream(fileName);
            FileChannel fc = fis.getChannel();
            long fileSize = fc.size();
            long readFileSizeEachNode = Math.max(1L, fileSize / 500L / 100L);
            int average_row_size = 0;
            Csv csv = new Csv();
            if (csvOptions != null && csvOptions.indexOf(61) >= 0) {
                csv.setOptions(csvOptions);
            }
            ResultSet reader = csv.read((Reader)new BufferedReader(new InputStreamReader(fis)), null);
            ResultSetMetaData metadata = reader.getMetaData();
            int columnCount = metadata.getColumnCount();
            StringBuilder createTable = new StringBuilder("CREATE TABLE ");
            createTable.append(outputTable).append("(");
            StringBuilder insertTable = new StringBuilder("INSERT INTO ");
            insertTable.append(outputTable).append(" VALUES(");
            for (int i = 0; i < columnCount; ++i) {
                if (i > 0) {
                    createTable.append(",");
                    insertTable.append(",");
                }
                createTable.append(metadata.getColumnName(i + 1)).append(" VARCHAR");
                insertTable.append("?");
            }
            createTable.append(")");
            insertTable.append(")");
            try (Statement stmt = connection.createStatement();){
                stmt.execute(createTable.toString());
            }
            connection.setAutoCommit(false);
            PreparedStatement pst = connection.prepareStatement(insertTable.toString());
            long batchSize = 0L;
            try {
                while (reader.next()) {
                    if (progress.isCanceled()) {
                        throw new SQLException("Canceled by user");
                    }
                    for (int i = 0; i < columnCount; ++i) {
                        pst.setString(i + 1, reader.getString(i + 1));
                    }
                    pst.addBatch();
                    if (++batchSize >= 100L) {
                        pst.executeBatch();
                        connection.commit();
                        pst.clearBatch();
                        batchSize = 0L;
                    }
                    if ((long)average_row_size++ % readFileSizeEachNode != 0L) continue;
                    try {
                        progress.setStep((int)((double)fc.position() / (double)fileSize * 100.0));
                    }
                    catch (IOException iOException) {}
                }
                if (batchSize > 0L) {
                    pst.executeBatch();
                    connection.commit();
                    pst.clearBatch();
                }
            }
            finally {
                pst.close();
                connection.setAutoCommit(true);
            }
            return new String[]{outputTable};
        }
        return null;
    }
}

