/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.fgb;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.h2.command.ddl.CreateTableData;
import org.h2.table.Column;
import org.h2.value.ExtTypeInfo;
import org.h2.value.ExtTypeInfoGeometry;
import org.h2.value.TypeInfo;
import org.h2gis.functions.io.fgb.fileTable.FGBDriver;
import org.h2gis.functions.io.file_table.FileEngine;
import org.wololo.flatgeobuf.ColumnMeta;
import org.wololo.flatgeobuf.HeaderMeta;

public class FGBEngine
extends FileEngine<FGBDriver> {
    @Override
    protected FGBDriver createDriver(File filePath, List<String> args) throws IOException {
        FGBDriver driver = new FGBDriver();
        driver.initDriverFromFile(filePath);
        return driver;
    }

    @Override
    protected void feedCreateTableData(FGBDriver driver, CreateTableData data) throws IOException {
        HeaderMeta header = driver.getHeader();
        byte geometryType = header.geometryType;
        boolean hasM = header.hasM;
        boolean hasZ = header.hasZ;
        int srid = header.srid;
        int geomType = 0;
        if (geometryType == 1) {
            geomType = hasM && hasM ? 3001 : (hasM ? 2001 : (hasZ ? 1001 : 1));
        } else if (geometryType == 2) {
            geomType = hasM && hasM ? 3002 : (hasM ? 2002 : (hasZ ? 1002 : 2));
        } else if (geometryType == 3) {
            geomType = hasM && hasM ? 3003 : (hasM ? 2003 : (hasZ ? 1003 : 3));
        } else if (geometryType == 4) {
            geomType = hasM && hasM ? 3004 : (hasM ? 2004 : (hasZ ? 1004 : 4));
        } else if (geometryType == 5) {
            geomType = hasM && hasM ? 3005 : (hasM ? 2005 : (hasZ ? 1005 : 5));
        } else if (geometryType == 6) {
            geomType = hasM && hasM ? 3006 : (hasM ? 2006 : (hasZ ? 1006 : 6));
        } else if (geometryType == 7) {
            geomType = hasM && hasM ? 3007 : (hasM ? 2007 : (hasZ ? 1007 : 7));
        }
        ExtTypeInfoGeometry extTypeInfo = new ExtTypeInfoGeometry(geomType, Integer.valueOf(srid));
        TypeInfo typeInfo = TypeInfo.getTypeInfo((int)TypeInfo.TYPE_GEOMETRY.getValueType(), (long)TypeInfo.TYPE_GEOMETRY.getPrecision(), (int)TypeInfo.TYPE_GEOMETRY.getScale(), (ExtTypeInfo)extTypeInfo);
        Column geometryColumn = new Column("THE_GEOM", typeInfo);
        data.columns.add(geometryColumn);
        List columns = header.columns;
        for (ColumnMeta col : columns) {
            Column column = new Column(col.name.toUpperCase(), FGBEngine.fgbTypeToH2Type(col));
            column.setComment(col.description);
            data.columns.add(column);
        }
    }

    private static TypeInfo fgbTypeToH2Type(ColumnMeta columnMeta) throws IOException {
        byte type = columnMeta.type;
        int precision = columnMeta.precision;
        int scale = columnMeta.scale;
        switch (type) {
            case 2: {
                return TypeInfo.TYPE_BOOLEAN;
            }
            case 11: {
                return TypeInfo.getTypeInfo((int)2, (long)columnMeta.width, (int)0, null);
            }
            case 13: {
                return TypeInfo.TYPE_DATE;
            }
            case 0: 
            case 3: 
            case 4: {
                return TypeInfo.TYPE_SMALLINT;
            }
            case 1: 
            case 5: 
            case 6: {
                return TypeInfo.TYPE_INTEGER;
            }
            case 7: 
            case 8: {
                return TypeInfo.TYPE_BIGINT;
            }
            case 9: 
            case 10: {
                if (precision == 0 || precision >= 25 && precision <= 53) {
                    return new TypeInfo(15, (long)precision, scale, null);
                }
                return TypeInfo.TYPE_DOUBLE;
            }
            case 12: {
                return TypeInfo.TYPE_JSON;
            }
            case 14: {
                return TypeInfo.TYPE_BINARY;
            }
        }
        throw new IOException("Unknown FGB field type " + type);
    }
}

