/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.geojson;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;
import org.h2.value.ValueVarchar;
import org.h2gis.api.AbstractFunction;
import org.h2gis.api.EmptyProgressVisitor;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.api.ScalarFunction;
import org.h2gis.functions.io.geojson.GeoJsonDriverFunction;
import org.h2gis.utilities.URIUtilities;

public class GeoJsonRead
extends AbstractFunction
implements ScalarFunction {
    public GeoJsonRead() {
        this.addProperty("remarks", "Import a GeoJSON 1.0 file.\n GeoJsonRead(...\n Supported arguments :\n path of the file\n path of the file, table name\n path of the file, table name, true to delete the table name\n path of the file, table name, encoding chartset\n path of the file, table name, encoding chartset, true to delete the table name");
    }

    public String getJavaStaticMethod() {
        return "importTable";
    }

    public static void importTable(Connection connection, String fileName) throws IOException, SQLException {
        String name = URIUtilities.fileFromString((String)fileName).getName();
        String tableName = name.substring(0, name.lastIndexOf(".")).replace(".", "_").toUpperCase();
        if (!tableName.matches("^[a-zA-Z][a-zA-Z0-9_]*$")) {
            throw new SQLException("The file name contains unsupported characters");
        }
        GeoJsonRead.importTable(connection, fileName, tableName, null, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void importTable(Connection connection, String fileName, Value option) throws IOException, SQLException {
        String tableReference = null;
        if (option instanceof ValueBoolean) {
            String name = URIUtilities.fileFromString((String)fileName).getName();
            String tableName = name.substring(0, name.lastIndexOf(".")).replace(".", "_").toUpperCase();
            if (!tableName.matches("^[a-zA-Z][a-zA-Z0-9_]*$")) throw new SQLException("The file name contains unsupported characters");
            GeoJsonRead.importTable(connection, fileName, tableName, null, option.getBoolean());
            return;
        } else if (option instanceof ValueVarchar) {
            tableReference = option.getString();
            GeoJsonRead.importTable(connection, fileName, tableReference, null, false);
            return;
        } else {
            if (option instanceof ValueNull) return;
            throw new SQLException("Supported optional parameter is boolean or varchar");
        }
    }

    public static void importTable(Connection connection, String fileName, String tableReference, Value option) throws IOException, SQLException {
        String encoding = null;
        boolean deleteTable = false;
        if (option instanceof ValueBoolean) {
            deleteTable = option.getBoolean();
        } else if (option instanceof ValueVarchar) {
            encoding = option.getString();
        } else if (!(option instanceof ValueNull)) {
            throw new SQLException("Supported optional parameter is boolean or varchar");
        }
        GeoJsonRead.importTable(connection, fileName, tableReference, encoding, deleteTable);
    }

    public static void importTable(Connection connection, String fileName, String tableReference, String encoding, boolean deleteTable) throws IOException, SQLException {
        GeoJsonDriverFunction gjdf = new GeoJsonDriverFunction();
        gjdf.importFile(connection, tableReference, URIUtilities.fileFromString((String)fileName), encoding, deleteTable, (ProgressVisitor)new EmptyProgressVisitor());
    }
}

