/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.convert;

import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

public class ST_Force4D
extends DeterministicScalarFunction {
    static final GeometryFactory gf = new GeometryFactory();

    public ST_Force4D() {
        this.addProperty("remarks", "Forces the geometries into XYZM mode.\n If a geometry has no Z  or M measure, then a z and m values are tacked on.Default z and m value are set to zero.");
    }

    public String getJavaStaticMethod() {
        return "force4D";
    }

    public static Geometry force4D(Geometry geom) {
        if (geom == null) {
            return null;
        }
        return ST_Force4D.force4D(geom, 0.0, 0.0);
    }

    public static Geometry force4D(Geometry geom, double zValue, double mValue) {
        if (geom == null) {
            return null;
        }
        return ST_Force4D.force(geom, zValue, mValue);
    }

    public static Geometry force(Geometry geom, double zValue, double mValue) {
        Geometry g = geom;
        if (geom instanceof Point) {
            g = gf.createPoint((CoordinateSequence)ST_Force4D.convertSequence(((Point)geom).getCoordinateSequence(), zValue, mValue));
            g.setSRID(geom.getSRID());
        } else if (geom instanceof LineString) {
            g = gf.createLineString((CoordinateSequence)ST_Force4D.convertSequence(((LineString)geom).getCoordinateSequence(), zValue, mValue));
            g.setSRID(geom.getSRID());
        } else if (geom instanceof Polygon) {
            g = ST_Force4D.convert((Polygon)geom, zValue, mValue);
            g.setSRID(geom.getSRID());
        } else if (geom instanceof MultiPoint) {
            g = ST_Force4D.convert((MultiPoint)geom, zValue, mValue);
            g.setSRID(geom.getSRID());
        } else if (geom instanceof MultiLineString) {
            g = ST_Force4D.convert((MultiLineString)geom, zValue, mValue);
            g.setSRID(geom.getSRID());
        } else if (geom instanceof MultiPolygon) {
            g = ST_Force4D.convert((MultiPolygon)geom, zValue, mValue);
            g.setSRID(geom.getSRID());
        } else if (geom instanceof GeometryCollection) {
            g = ST_Force4D.convert((GeometryCollection)geom, zValue, mValue);
            g.setSRID(geom.getSRID());
        }
        return g;
    }

    public static MultiPoint convert(MultiPoint mp, double zValue, double mValue) {
        int nb = mp.getNumGeometries();
        Point[] geometries = new Point[nb];
        for (int i = 0; i < nb; ++i) {
            geometries[i] = (Point)ST_Force4D.force(mp.getGeometryN(i), zValue, mValue);
        }
        return gf.createMultiPoint(geometries);
    }

    public static GeometryCollection convert(GeometryCollection gc, double zValue, double mValue) {
        int nb = gc.getNumGeometries();
        Geometry[] geometries = new Geometry[nb];
        for (int i = 0; i < nb; ++i) {
            geometries[i] = ST_Force4D.force(gc.getGeometryN(i), zValue, mValue);
        }
        return gf.createGeometryCollection(geometries);
    }

    public static MultiPolygon convert(MultiPolygon multiPolygon, double zValue, double mValue) {
        int nb = multiPolygon.getNumGeometries();
        Polygon[] pl = new Polygon[nb];
        for (int i = 0; i < nb; ++i) {
            pl[i] = ST_Force4D.convert((Polygon)multiPolygon.getGeometryN(i), zValue, mValue);
        }
        return gf.createMultiPolygon(pl);
    }

    public static MultiLineString convert(MultiLineString multiLineString, double zValue, double mValue) {
        int nb = multiLineString.getNumGeometries();
        LineString[] ls = new LineString[nb];
        for (int i = 0; i < nb; ++i) {
            ls[i] = ST_Force4D.convert((LineString)multiLineString.getGeometryN(i), zValue, mValue);
        }
        return gf.createMultiLineString(ls);
    }

    public static Polygon convert(Polygon polygon, double zValue, double mValue) {
        LinearRing shell = gf.createLinearRing((CoordinateSequence)ST_Force4D.convertSequence(polygon.getExteriorRing().getCoordinateSequence(), zValue, mValue));
        int nbOfHoles = polygon.getNumInteriorRing();
        LinearRing[] holes = new LinearRing[nbOfHoles];
        for (int i = 0; i < nbOfHoles; ++i) {
            holes[i] = gf.createLinearRing((CoordinateSequence)ST_Force4D.convertSequence(polygon.getInteriorRingN(i).getCoordinateSequence(), zValue, mValue));
        }
        return gf.createPolygon(shell, holes);
    }

    public static LineString convert(LineString lineString, double zValue, double mValue) {
        return gf.createLineString((CoordinateSequence)ST_Force4D.convertSequence(lineString.getCoordinateSequence(), zValue, mValue));
    }

    public static LinearRing convert(LinearRing linearRing, double zValue, double mValue) {
        return gf.createLinearRing((CoordinateSequence)ST_Force4D.convertSequence(linearRing.getCoordinateSequence(), zValue, mValue));
    }

    private static CoordinateArraySequence convertSequence(CoordinateSequence cs, double zValue, double mValue) {
        boolean hasM = false;
        if (cs.getMeasures() == 1) {
            hasM = true;
        }
        Coordinate[] coords = new Coordinate[cs.size()];
        for (int i = 0; i < cs.size(); ++i) {
            double z_tmp;
            double mValue_;
            Coordinate coord = cs.getCoordinate(i);
            if (hasM && !Double.isNaN(mValue_ = coord.getM())) {
                mValue = mValue_;
            }
            if (!Double.isNaN(z_tmp = coord.getZ())) {
                zValue = z_tmp;
            }
            coords[i] = new CoordinateXYZM(coord.x, coord.y, zValue, mValue);
        }
        return new CoordinateArraySequence(coords, 4);
    }
}

