/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.edit;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

public class ST_ForcePolygonCCW
extends DeterministicScalarFunction {
    public ST_ForcePolygonCCW() {
        this.addProperty("remarks", "Forces (Multi)Polygons to use a counter-clockwise orientation for their exterior ring, and a clockwise orientation for their interior rings.\n Non-polygonal geometries are returned unchanged.");
    }

    public String getJavaStaticMethod() {
        return "execute";
    }

    public static Geometry execute(Geometry geom) throws SQLException {
        if (geom != null) {
            LinkedList<Geometry> geometries = new LinkedList<Geometry>();
            ST_ForcePolygonCCW.forcePolygonCCW(geom, geometries);
            return geom.getFactory().buildGeometry(geometries);
        }
        return null;
    }

    private static void forcePolygonCCW(Geometry geometry, List<Geometry> geometries) throws SQLException {
        if (geometry instanceof Polygon) {
            ST_ForcePolygonCCW.forcePolygonCCW((Polygon)geometry, geometries);
        } else if (geometry instanceof GeometryCollection) {
            ST_ForcePolygonCCW.forcePolygonCCW((GeometryCollection)geometry, geometries);
        } else {
            geometries.add(geometry);
        }
    }

    private static void forcePolygonCCW(Polygon polygon, List<Geometry> geometries) {
        LinearRing ring = polygon.getExteriorRing();
        if (!Orientation.isCCW((CoordinateSequence)ring.getCoordinateSequence())) {
            ring = ring.reverse();
        }
        int nb = polygon.getNumInteriorRing();
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        for (int i = 0; i < nb; ++i) {
            LinearRing hole = polygon.getInteriorRingN(i);
            if (Orientation.isCCW((CoordinateSequence)hole.getCoordinateSequence())) {
                holes.add(hole.reverse());
                continue;
            }
            holes.add(hole);
        }
        geometries.add((Geometry)polygon.getFactory().createPolygon(ring, holes.toArray(new LinearRing[0])));
    }

    private static void forcePolygonCCW(GeometryCollection geometryCollection, List<Geometry> geometries) throws SQLException {
        int size = geometryCollection.getNumGeometries();
        for (int i = 0; i < size; ++i) {
            ST_ForcePolygonCCW.forcePolygonCCW(geometryCollection.getGeometryN(i), geometries);
        }
    }
}

