/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.split;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.functions.spatial.convert.ST_ToMultiSegments;
import org.h2gis.functions.spatial.edit.EditUtilities;
import org.h2gis.utilities.jts_utils.CoordinateUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.distance.GeometryLocation;
import org.locationtech.jts.operation.polygonize.Polygonizer;
import org.locationtech.jts.operation.union.UnaryUnionOp;

public class ST_Split
extends DeterministicScalarFunction {
    private static final GeometryFactory FACTORY = new GeometryFactory();
    public static final double PRECISION = 1.0E-5;

    public ST_Split() {
        this.addProperty("remarks", "Returns a collection of geometries resulting by splitting a geometry.\nSupported operations are : - split a polygon or a multipolygon by a linestring,\n- split a linestring or a multilinestring by a linestring,\n- split a linestring or a multilinestring by a point. At this stage a double tolerance\ncan be used to snap the point.\nNote :  XYZ dimension is only supported when the linestring or a multilinestring is splited by a point");
    }

    public String getJavaStaticMethod() {
        return "split";
    }

    public static Geometry split(Geometry geomA, Geometry geomB) throws SQLException {
        if (geomA == null || geomB == null) {
            return null;
        }
        if (geomA.getSRID() != geomB.getSRID()) {
            throw new SQLException("Operation on mixed SRID geometries not supported");
        }
        if (geomA instanceof Polygon) {
            return ST_Split.splitPolygonWithLine((Polygon)geomA, (LineString)geomB);
        }
        if (geomA instanceof MultiPolygon) {
            return ST_Split.splitMultiPolygonWithLine((MultiPolygon)geomA, (LineString)geomB);
        }
        if (geomA instanceof LineString) {
            if (geomB instanceof LineString) {
                return ST_Split.splitLineStringWithLine((LineString)geomA, (LineString)geomB);
            }
            if (geomB instanceof Point) {
                return ST_Split.splitLineWithPoint((LineString)geomA, (Point)geomB, 1.0E-5);
            }
        } else if (geomA instanceof MultiLineString) {
            if (geomB instanceof LineString) {
                return ST_Split.splitMultiLineStringWithLine((MultiLineString)geomA, (LineString)geomB);
            }
            if (geomB instanceof Point) {
                return ST_Split.splitMultiLineStringWithPoint((MultiLineString)geomA, (Point)geomB, 1.0E-5);
            }
        }
        throw new SQLException("Split a " + geomA.getGeometryType() + " by a " + geomB.getGeometryType() + " is not supported.");
    }

    public static Geometry split(Geometry geomA, Geometry geomB, double tolerance) throws SQLException {
        if (geomA instanceof Polygon) {
            throw new SQLException("Split a Polygon by a line is not supported using a tolerance. \nPlease used ST_Split(geom1, geom2)");
        }
        if (geomA instanceof LineString) {
            if (geomB instanceof LineString) {
                throw new SQLException("Split a line by a line is not supported using a tolerance. \nPlease used ST_Split(geom1, geom2)");
            }
            if (geomB instanceof Point) {
                return ST_Split.splitLineWithPoint((LineString)geomA, (Point)geomB, tolerance);
            }
        } else if (geomA instanceof MultiLineString) {
            if (geomB instanceof LineString) {
                throw new SQLException("Split a multiline by a line is not supported using a tolerance. \nPlease used ST_Split(geom1, geom2)");
            }
            if (geomB instanceof Point) {
                return ST_Split.splitMultiLineStringWithPoint((MultiLineString)geomA, (Point)geomB, tolerance);
            }
        }
        throw new SQLException("Split a " + geomA.getGeometryType() + " by a " + geomB.getGeometryType() + " is not supported.");
    }

    private static MultiLineString splitLineWithPoint(LineString line, Point pointToSplit, double tolerance) {
        return FACTORY.createMultiLineString(ST_Split.splitLineStringWithPoint(line, pointToSplit, tolerance));
    }

    private static LineString[] splitLineStringWithPoint(LineString line, Point pointToSplit, double tolerance) {
        Coordinate[] coords = line.getCoordinates();
        Coordinate firstCoord = coords[0];
        Coordinate lastCoord = coords[coords.length - 1];
        Coordinate coordToSplit = pointToSplit.getCoordinate();
        if (coordToSplit.distance(firstCoord) <= 1.0E-5 || coordToSplit.distance(lastCoord) <= 1.0E-5) {
            return new LineString[]{line};
        }
        ArrayList<Coordinate> firstLine = new ArrayList<Coordinate>();
        firstLine.add(coords[0]);
        ArrayList<Coordinate> secondLine = new ArrayList<Coordinate>();
        GeometryLocation geometryLocation = EditUtilities.getVertexToSnap((Geometry)line, pointToSplit, tolerance);
        if (geometryLocation != null) {
            int segmentIndex = geometryLocation.getSegmentIndex();
            Coordinate coord = geometryLocation.getCoordinate();
            int index = -1;
            for (int i = 1; i < coords.length; ++i) {
                index = i - 1;
                if (index < segmentIndex) {
                    firstLine.add(coords[i]);
                    continue;
                }
                if (index == segmentIndex) {
                    coord.z = CoordinateUtils.interpolate((Coordinate)coords[i - 1], (Coordinate)coords[i], (Coordinate)coord);
                    firstLine.add(coord);
                    secondLine.add(coord);
                    if (coord.equals2D(coords[i])) continue;
                    secondLine.add(coords[i]);
                    continue;
                }
                secondLine.add(coords[i]);
            }
            LineString lineString1 = FACTORY.createLineString(firstLine.toArray(new Coordinate[0]));
            LineString lineString2 = FACTORY.createLineString(secondLine.toArray(new Coordinate[0]));
            return new LineString[]{lineString1, lineString2};
        }
        return null;
    }

    private static MultiLineString splitMultiLineStringWithPoint(MultiLineString multiLineString, Point pointToSplit, double tolerance) {
        ArrayList<LineString> linestrings = new ArrayList<LineString>();
        boolean notChanged = true;
        int nb = multiLineString.getNumGeometries();
        for (int i = 0; i < nb; ++i) {
            LineString subGeom = (LineString)multiLineString.getGeometryN(i);
            LineString[] result = ST_Split.splitLineStringWithPoint(subGeom, pointToSplit, tolerance);
            if (result != null) {
                Collections.addAll(linestrings, result);
                notChanged = false;
                continue;
            }
            linestrings.add(subGeom);
        }
        if (!notChanged) {
            return FACTORY.createMultiLineString(linestrings.toArray(new LineString[0]));
        }
        return null;
    }

    private static Collection<Polygon> splitPolygonizer(Polygon polygon, LineString lineString) throws SQLException {
        LinkedList<LineString> result = new LinkedList<LineString>();
        ST_ToMultiSegments.createSegments((LineString)polygon.getExteriorRing(), result);
        result.add(lineString);
        int holes = polygon.getNumInteriorRing();
        for (int i = 0; i < holes; ++i) {
            ST_ToMultiSegments.createSegments((LineString)polygon.getInteriorRingN(i), result);
        }
        UnaryUnionOp uOp = new UnaryUnionOp(result);
        Geometry union = uOp.union();
        Polygonizer polygonizer = new Polygonizer();
        polygonizer.add(union);
        Collection polygons = polygonizer.getPolygons();
        if (polygons.size() > 1) {
            return polygons;
        }
        return null;
    }

    private static Geometry splitPolygonWithLine(Polygon polygon, LineString lineString) throws SQLException {
        Collection<Polygon> pols = ST_Split.polygonWithLineSplitter(polygon, lineString);
        if (pols != null) {
            return FACTORY.buildGeometry(ST_Split.polygonWithLineSplitter(polygon, lineString));
        }
        return null;
    }

    private static Collection<Polygon> polygonWithLineSplitter(Polygon polygon, LineString lineString) throws SQLException {
        Collection<Polygon> polygons = ST_Split.splitPolygonizer(polygon, lineString);
        if (polygons != null && polygons.size() > 1) {
            ArrayList<Polygon> pols = new ArrayList<Polygon>();
            for (Polygon pol : polygons) {
                if (!polygon.contains((Geometry)pol.getInteriorPoint())) continue;
                pols.add(pol);
            }
            return pols;
        }
        return null;
    }

    private static Geometry splitMultiPolygonWithLine(MultiPolygon multiPolygon, LineString lineString) throws SQLException {
        ArrayList<Polygon> allPolygons = new ArrayList<Polygon>();
        for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
            Collection<Polygon> polygons = ST_Split.splitPolygonizer((Polygon)multiPolygon.getGeometryN(i), lineString);
            if (polygons == null) continue;
            allPolygons.addAll(polygons);
        }
        if (!allPolygons.isEmpty()) {
            return FACTORY.buildGeometry(allPolygons);
        }
        return null;
    }

    private static Geometry splitLineStringWithLine(LineString input, LineString cut) {
        return input.difference((Geometry)cut);
    }

    private static Geometry splitMultiLineStringWithLine(MultiLineString input, LineString cut) {
        Geometry lines = input.difference((Geometry)cut);
        if (lines instanceof LineString) {
            return FACTORY.createMultiLineString(new LineString[]{(LineString)lines.getGeometryN(0)});
        }
        return lines;
    }
}

