/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.topology;

import java.util.Collection;
import java.util.HashSet;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.utilities.jts_utils.RobustLineIntersector3D;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.noding.IntersectionAdder;
import org.locationtech.jts.noding.MCIndexNoder;
import org.locationtech.jts.noding.SegmentIntersector;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.noding.SegmentStringUtil;

public class ST_Node
extends DeterministicScalarFunction {
    public ST_Node() {
        this.addProperty("remarks", "Add nodes on a geometry for each intersection.\nDuplicate lines are removed ");
    }

    public String getJavaStaticMethod() {
        return "node";
    }

    public static Geometry node(Geometry geom) {
        if (geom == null) {
            return null;
        }
        MCIndexNoder noder = new MCIndexNoder((SegmentIntersector)new IntersectionAdder((LineIntersector)new RobustLineIntersector3D()));
        noder.computeNodes((Collection)SegmentStringUtil.extractNodedSegmentStrings((Geometry)geom));
        Collection segStrings = noder.getNodedSubstrings();
        GeometryFactory geomFact = geom.getFactory();
        HashSet<LineString> lines = new HashSet<LineString>();
        for (SegmentString ss : segStrings) {
            LineString line = geomFact.createLineString(ss.getCoordinates());
            lines.add(line);
        }
        return geomFact.createMultiLineString(lines.toArray(lines.toArray(new LineString[0])));
    }
}

