/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.kml;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2gis.api.DriverFunction;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.functions.io.DriverManager;
import org.h2gis.functions.io.kml.KMLWriterDriver;

public class KMLDriverFunction
implements DriverFunction {
    public String[] getImportFormats() {
        return new String[0];
    }

    public String[] getExportFormats() {
        return new String[]{"kml", "kmz"};
    }

    public String getFormatDescription(String format) {
        if (format.equalsIgnoreCase("kml")) {
            return "KML 2.2";
        }
        if (format.equalsIgnoreCase("kmz")) {
            return "KMZ 2.2";
        }
        return "";
    }

    public boolean isSpatialFormat(String extension) {
        return extension.equalsIgnoreCase("kml") || extension.equalsIgnoreCase("kmz");
    }

    public String[] exportTable(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        return this.exportTable(connection, tableReference, fileName, null, false, progress);
    }

    public String[] exportTable(Connection connection, String tableReference, File fileName, boolean deleteFiles, ProgressVisitor progress) throws SQLException, IOException {
        return this.exportTable(connection, tableReference, fileName, null, deleteFiles, progress);
    }

    public String[] exportTable(Connection connection, String tableReference, File fileName, String options, boolean deleteFiles, ProgressVisitor progress) throws SQLException, IOException {
        progress = DriverManager.check(connection, tableReference, fileName, progress);
        KMLWriterDriver kMLWriter = new KMLWriterDriver(connection, fileName, options, deleteFiles);
        try {
            kMLWriter.write(tableReference, progress);
            return new String[]{fileName.getAbsolutePath()};
        }
        catch (IOException | SQLException ex) {
            throw new SQLException(ex);
        }
    }

    public String[] exportTable(Connection connection, String tableReference, File fileName, String encoding, ProgressVisitor progress) throws SQLException, IOException {
        return this.exportTable(connection, tableReference, fileName, encoding, false, progress);
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, String options, ProgressVisitor progress) throws SQLException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, boolean deleteTables, ProgressVisitor progress) throws SQLException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, String options, boolean deleteTables, ProgressVisitor progress) throws SQLException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DriverFunction.IMPORT_DRIVER_TYPE getImportDriverType() {
        return DriverFunction.IMPORT_DRIVER_TYPE.COPY;
    }
}

