/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.shp;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.h2.table.Column;
import org.h2.util.JdbcUtils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2gis.api.DriverFunction;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.functions.io.DriverManager;
import org.h2gis.functions.io.dbf.DBFDriverFunction;
import org.h2gis.functions.io.dbf.internal.DbaseFileHeader;
import org.h2gis.functions.io.file_table.FileEngine;
import org.h2gis.functions.io.shp.internal.SHPDriver;
import org.h2gis.functions.io.shp.internal.ShapeType;
import org.h2gis.functions.io.shp.internal.ShapefileHeader;
import org.h2gis.functions.io.utility.PRJUtil;
import org.h2gis.utilities.FileUtilities;
import org.h2gis.utilities.GeometryMetaData;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.Tuple;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.h2gis.utilities.dbtypes.DBUtils;
import org.locationtech.jts.geom.Geometry;

public class SHPDriverFunction
implements DriverFunction {
    public static String DESCRIPTION = "ESRI shapefile";
    private static final int BATCH_MAX_SIZE = 100;

    public String[] exportTable(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        return this.exportTable(connection, tableReference, fileName, null, progress);
    }

    public String[] exportTable(Connection connection, String tableReference, File fileName, boolean deleteFiles, ProgressVisitor progress) throws SQLException, IOException {
        return this.exportTable(connection, tableReference, fileName, null, deleteFiles, progress);
    }

    public String[] exportTable(Connection connection, String tableReference, File fileName, String options, boolean deleteFiles, ProgressVisitor progress) throws SQLException, IOException {
        String nameWithoutExt;
        String path;
        progress = DriverManager.check(connection, tableReference, fileName, progress);
        if (!FileUtilities.isExtensionWellFormated((File)fileName, (String)"shp")) {
            throw new SQLException("Only .shp extension is supported");
        }
        if (deleteFiles) {
            path = fileName.getAbsolutePath();
            nameWithoutExt = path.substring(0, path.lastIndexOf(46));
            Files.deleteIfExists(fileName.toPath());
            Files.deleteIfExists(new File(nameWithoutExt + ".dbf").toPath());
            Files.deleteIfExists(new File(nameWithoutExt + ".shx").toPath());
            Files.deleteIfExists(new File(nameWithoutExt + ".prj").toPath());
        } else {
            path = fileName.getAbsolutePath();
            nameWithoutExt = path.substring(0, path.lastIndexOf(46));
            if (fileName.exists() || new File(nameWithoutExt + ".dbf").exists() || new File(nameWithoutExt + ".shx").exists() || new File(nameWithoutExt + ".prj").exists()) {
                throw new IOException("The file already exist.");
            }
        }
        DBTypes dbType = DBUtils.getDBType((Connection)connection);
        String regex = ".*(?i)\\b(select|from)\\b.*";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(tableReference);
        if (matcher.find()) {
            if (tableReference.startsWith("(") && tableReference.endsWith(")")) {
                PreparedStatement ps = connection.prepareStatement(tableReference, 1004, 1007);
                JDBCUtilities.attachCancelResultSet((Statement)ps, (ProgressVisitor)progress);
                ResultSet resultSet = ps.executeQuery();
                int recordCount = 0;
                resultSet.last();
                recordCount = resultSet.getRow();
                resultSet.beforeFirst();
                ProgressVisitor copyProgress = progress.subProcess(recordCount);
                Tuple spatialFieldNameAndIndex = GeometryTableUtilities.getFirstGeometryColumnNameAndIndex((ResultSet)resultSet);
                String[] files = this.doExport(connection, (Integer)spatialFieldNameAndIndex.second(), resultSet, recordCount, fileName, progress, options);
                copyProgress.endOfProgress();
                return files;
            }
            throw new SQLException("The select query must be enclosed in parenthesis: '(SELECT * FROM ORDERS)'.");
        }
        TableLocation tableLocation = TableLocation.parse((String)tableReference, (DBTypes)dbType);
        String location = tableLocation.toString(dbType);
        int recordCount = JDBCUtilities.getRowCount((Connection)connection, (String)location);
        ProgressVisitor copyProgress = progress.subProcess(recordCount);
        Tuple spatialFieldNameAndIndex = GeometryTableUtilities.getFirstGeometryColumnNameAndIndex((Connection)connection, (TableLocation)tableLocation);
        Statement st = connection.createStatement();
        JDBCUtilities.attachCancelResultSet((Statement)st, (ProgressVisitor)progress);
        ResultSet rs = st.executeQuery(String.format("select * from %s", location));
        String[] files = this.doExport(connection, (Integer)spatialFieldNameAndIndex.second(), rs, recordCount, fileName, copyProgress, options);
        copyProgress.endOfProgress();
        return files;
    }

    public String[] exportTable(Connection connection, String tableReference, File fileName, String encoding, ProgressVisitor progress) throws SQLException, IOException {
        return this.exportTable(connection, tableReference, fileName, encoding, false, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] doExport(Connection connection, Integer spatialFieldIndex, ResultSet rs, int recordCount, File fileName, ProgressVisitor progress, String encoding) throws SQLException, IOException {
        int srid = 0;
        ShapeType shapeType = null;
        try {
            ResultSetMetaData resultSetMetaData = rs.getMetaData();
            ArrayList<Integer> columnIndexes = new ArrayList<Integer>();
            DbaseFileHeader header = DBFDriverFunction.dBaseHeaderFromMetaData(resultSetMetaData, columnIndexes);
            columnIndexes.add(0, spatialFieldIndex);
            if (encoding != null && !encoding.isEmpty()) {
                header.setEncoding(encoding);
            }
            header.setNumRecords(recordCount);
            SHPDriver shpDriver = null;
            Object[] row = new Object[header.getNumFields() + 1];
            while (rs.next()) {
                int i = 0;
                for (Integer index : columnIndexes) {
                    row[i++] = rs.getObject(index);
                }
                if (shpDriver == null) {
                    Geometry wkb = (Geometry)rs.getObject(spatialFieldIndex);
                    if (wkb != null) {
                        GeometryMetaData gm = GeometryMetaData.getMetaData((Geometry)wkb);
                        if (srid == 0) {
                            srid = gm.SRID;
                        }
                        shapeType = SHPDriverFunction.getShapeTypeFromGeometryMetaData(gm);
                    }
                    if (shapeType != null) {
                        shpDriver = new SHPDriver();
                        shpDriver.setGeometryFieldIndex(0);
                        shpDriver.initDriver(fileName, shapeType, header);
                    } else {
                        throw new SQLException("Unsupported geometry type.");
                    }
                }
                if (shpDriver != null) {
                    shpDriver.insertRow(row);
                }
                progress.endStep();
            }
            if (shpDriver != null) {
                shpDriver.close();
            }
            if (srid >= 0) {
                String path = fileName.getAbsolutePath();
                String nameWithoutExt = path.substring(0, path.lastIndexOf(46));
                File outPrjFile = new File(nameWithoutExt + ".prj");
                PRJUtil.writePRJ(connection, srid, outPrjFile);
                String[] stringArray = new String[]{shpDriver.shpFile.getAbsolutePath(), shpDriver.shxFile.getAbsolutePath(), shpDriver.dbfFile.getAbsolutePath(), outPrjFile.getAbsolutePath()};
                return stringArray;
            }
            String[] stringArray = new String[]{shpDriver.shpFile.getAbsolutePath(), shpDriver.shxFile.getAbsolutePath(), shpDriver.dbfFile.getAbsolutePath()};
            return stringArray;
        }
        finally {
            rs.close();
        }
    }

    public String getFormatDescription(String format) {
        if (format.equalsIgnoreCase("shp")) {
            return DESCRIPTION;
        }
        return "";
    }

    public DriverFunction.IMPORT_DRIVER_TYPE getImportDriverType() {
        return DriverFunction.IMPORT_DRIVER_TYPE.COPY;
    }

    public String[] getImportFormats() {
        return new String[]{"shp"};
    }

    public String[] getExportFormats() {
        return new String[]{"shp"};
    }

    public boolean isSpatialFormat(String extension) {
        return extension.equalsIgnoreCase("shp");
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        return this.importFile(connection, tableReference, fileName, null, progress);
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, String forceEncoding, ProgressVisitor progress) throws SQLException, IOException {
        return this.importFile(connection, tableReference, fileName, null, false, progress);
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, boolean deleteTables, ProgressVisitor progress) throws SQLException, IOException {
        return this.importFile(connection, tableReference, fileName, null, deleteTables, progress);
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, String options, boolean deleteTables, ProgressVisitor progress) throws SQLException, IOException {
        progress = DriverManager.check(connection, tableReference, fileName, progress);
        DBTypes dbType = DBUtils.getDBType((Connection)connection);
        if (FileUtilities.isFileImportable((File)fileName, (String)"shp")) {
            TableLocation requestedTable = TableLocation.parse((String)tableReference, (DBTypes)dbType);
            String outputTableName = requestedTable.toString();
            if (deleteTables) {
                Statement stmt = connection.createStatement();
                stmt.execute("DROP TABLE IF EXISTS " + outputTableName);
                stmt.close();
            }
            SHPDriver shpDriver = new SHPDriver();
            shpDriver.initDriverFromFile(fileName, options);
            ProgressVisitor copyProgress = progress.subProcess((int)(shpDriver.getRowCount() / 100L));
            String lastSql = "";
            int dbfNumFields = 0;
            try {
                String[] stringArray;
                block28: {
                    DbaseFileHeader dbfHeader = shpDriver.getDbaseFileHeader();
                    ShapefileHeader shpHeader = shpDriver.getShapeFileHeader();
                    try (Statement st = connection.createStatement();){
                        dbfNumFields = dbfHeader.getNumFields();
                        ArrayList<Column> otherCols = new ArrayList<Column>(dbfNumFields + 1);
                        otherCols.add(new Column("THE_GEOM", TypeInfo.TYPE_GEOMETRY));
                        Object types = DBFDriverFunction.getSQLColumnTypes(dbfHeader, DBUtils.getDBType((Connection)connection), otherCols);
                        if (!((String)types).isEmpty()) {
                            types = ", " + (String)types;
                        }
                        String pkColName = FileEngine.getUniqueColumnName("PK", otherCols);
                        int srid = PRJUtil.getSRID(shpDriver.prjFile);
                        shpDriver.setSRID(srid);
                        st.execute(String.format("CREATE TABLE %s (" + pkColName + " INT PRIMARY KEY , the_geom GEOMETRY(%s, %d) %s)", requestedTable, SHPDriverFunction.getSFSGeometryType(shpHeader), srid, types));
                    }
                    connection.setAutoCommit(false);
                    lastSql = String.format("INSERT INTO %s VALUES (?, %s )", outputTableName, DBFDriverFunction.getQuestionMark(dbfNumFields + 1));
                    int columnCount = dbfNumFields + 1;
                    connection.setAutoCommit(false);
                    PreparedStatement preparedStatement = connection.prepareStatement(lastSql);
                    try {
                        long batchSize = 0L;
                        int rowId = 0;
                        while ((long)rowId < shpDriver.getRowCount()) {
                            preparedStatement.setInt(1, rowId + 1);
                            for (int columnId = 0; columnId < columnCount; ++columnId) {
                                JdbcUtils.set((PreparedStatement)preparedStatement, (int)(columnId + 2), (Value)shpDriver.getField(rowId, columnId), null);
                            }
                            preparedStatement.addBatch();
                            if (++batchSize >= 100L) {
                                preparedStatement.executeBatch();
                                connection.commit();
                                preparedStatement.clearBatch();
                                batchSize = 0L;
                                copyProgress.endStep();
                            }
                            ++rowId;
                        }
                        if (batchSize > 0L) {
                            preparedStatement.executeBatch();
                            connection.commit();
                        }
                        stringArray = new String[]{outputTableName};
                        if (preparedStatement == null) break block28;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                if (preparedStatement != null) {
                                    try {
                                        preparedStatement.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception ex) {
                                connection.createStatement().execute("DROP TABLE IF EXISTS " + outputTableName);
                                connection.commit();
                                throw new SQLException(ex.getLocalizedMessage(), ex);
                            }
                        }
                        catch (SQLException ex) {
                            throw new SQLException(lastSql + "\n" + ex.getLocalizedMessage(), ex);
                        }
                    }
                    preparedStatement.close();
                }
                return stringArray;
            }
            finally {
                connection.setAutoCommit(true);
                shpDriver.close();
                copyProgress.endOfProgress();
                connection.setAutoCommit(true);
            }
        }
        return null;
    }

    private static ShapeType getShapeTypeFromGeometryMetaData(GeometryMetaData meta) throws SQLException {
        ShapeType shapeType;
        switch (meta.geometryTypeCode) {
            case 2: 
            case 5: 
            case 1002: 
            case 1005: 
            case 2002: 
            case 2005: {
                shapeType = meta.hasZ ? ShapeType.ARCZ : ShapeType.ARC;
                break;
            }
            case 1: 
            case 1001: 
            case 2001: {
                shapeType = meta.hasZ ? ShapeType.POINTZ : ShapeType.POINT;
                break;
            }
            case 4: 
            case 1004: 
            case 2004: {
                shapeType = meta.hasZ ? ShapeType.MULTIPOINTZ : ShapeType.MULTIPOINT;
                break;
            }
            case 3: 
            case 6: 
            case 1003: 
            case 1006: 
            case 2003: 
            case 2006: {
                shapeType = meta.hasZ ? ShapeType.POLYGONZ : ShapeType.POLYGON;
                break;
            }
            default: {
                return null;
            }
        }
        return shapeType;
    }

    private static String getSFSGeometryType(ShapefileHeader header) {
        switch (header.getShapeType().id) {
            case 1: {
                return "POINT";
            }
            case 11: 
            case 21: {
                return "POINTZ";
            }
            case 3: {
                return "MULTILINESTRING";
            }
            case 13: 
            case 23: {
                return "MULTILINESTRINGZ";
            }
            case 5: {
                return "MULTIPOLYGON";
            }
            case 15: 
            case 25: {
                return "MULTIPOLYGONZ";
            }
            case 8: {
                return "MULTIPOINT";
            }
            case 18: 
            case 28: {
                return "MULTIPOINTZ";
            }
        }
        return "GEOMETRY";
    }
}

