/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.shp.internal;

import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.h2gis.functions.io.shp.internal.ShapeHandler;
import org.h2gis.functions.io.shp.internal.ShapeType;
import org.h2gis.functions.io.shp.internal.ShapefileException;
import org.h2gis.functions.io.shp.internal.ShapefileHeader;
import org.h2gis.functions.io.utility.WriteBufferManager;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class ShapefileWriter {
    private FileChannel shpChannel;
    private FileChannel shxChannel;
    private WriteBufferManager shapeBuffer;
    private WriteBufferManager indexBuffer;
    private ShapeHandler handler;
    private ShapeType type;
    private int offset;
    private int cnt = 0;
    private Envelope bounds;

    public ShapefileWriter(FileChannel shpChannel, FileChannel shxChannel) throws IOException {
        this.shpChannel = shpChannel;
        this.shxChannel = shxChannel;
    }

    public FileChannel getShpChannel() {
        return this.shpChannel;
    }

    public void writeHeaders(ShapeType type) throws IOException {
        try {
            this.handler = type.getShapeHandler();
        }
        catch (ShapefileException se) {
            throw new IOException("Error with type " + type, se);
        }
        if (this.indexBuffer != null) {
            this.indexBuffer.flush();
        }
        if (this.shapeBuffer != null) {
            this.shapeBuffer.flush();
        }
        long fileLength = this.shpChannel.position();
        this.shpChannel.position(0L);
        this.shxChannel.position(0L);
        ShapefileHeader header = new ShapefileHeader();
        Envelope writeBounds = this.bounds;
        if (writeBounds == null) {
            writeBounds = new Envelope();
        }
        this.indexBuffer = new WriteBufferManager(this.shxChannel);
        this.shapeBuffer = new WriteBufferManager(this.shpChannel);
        header.write(this.shapeBuffer, type, this.cnt, (int)(fileLength / 2L), writeBounds.getMinX(), writeBounds.getMinY(), writeBounds.getMaxX(), writeBounds.getMaxY());
        header.write(this.indexBuffer, type, this.cnt, 50 + 4 * this.cnt, writeBounds.getMinX(), writeBounds.getMinY(), writeBounds.getMaxX(), writeBounds.getMaxY());
        this.offset = 50;
        this.type = type;
    }

    public void writeGeometry(Geometry g) throws IOException {
        if (this.type == null) {
            throw new IllegalStateException("Header must be written before writeGeometry");
        }
        if (this.bounds != null) {
            if (g != null) {
                this.bounds.expandToInclude(g.getEnvelopeInternal());
            }
        } else {
            this.bounds = g.getEnvelopeInternal();
        }
        int length = g == null ? 4 : this.handler.getLength(g);
        this.shapeBuffer.order(ByteOrder.BIG_ENDIAN);
        this.shapeBuffer.putInt(++this.cnt);
        this.shapeBuffer.putInt(length /= 2);
        this.shapeBuffer.order(ByteOrder.LITTLE_ENDIAN);
        if (g == null || g.isEmpty()) {
            this.shapeBuffer.putInt(0);
        } else {
            this.shapeBuffer.putInt(this.type.id);
            this.handler.write(this.shapeBuffer, g);
        }
        this.indexBuffer.putInt(this.offset);
        this.indexBuffer.putInt(length);
        this.offset += length + 4;
    }

    public void close() throws IOException {
        this.indexBuffer.flush();
        this.shapeBuffer.flush();
        if (this.shpChannel != null && this.shpChannel.isOpen()) {
            this.shpChannel.close();
        }
        if (this.shxChannel != null && this.shxChannel.isOpen()) {
            this.shxChannel.close();
        }
        this.shpChannel = null;
        this.shxChannel = null;
        this.handler = null;
        this.indexBuffer = null;
        this.shapeBuffer = null;
    }
}

