/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.create;

import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.algorithm.construct.LargestEmptyCircle;
import org.locationtech.jts.algorithm.construct.MaximumInscribedCircle;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class ST_MaximumInscribedCircle
extends DeterministicScalarFunction {
    public ST_MaximumInscribedCircle() {
        this.addProperty("remarks", "Compute the largest circle that is contained within a (multi)polygon or the largest circle of a set of geometries constrained by their envelope.");
    }

    public String getJavaStaticMethod() {
        return "execute";
    }

    public static Geometry execute(Geometry geometry) throws SQLException {
        double height;
        if (geometry == null) {
            return null;
        }
        if (geometry.isEmpty()) {
            return geometry;
        }
        Envelope env = geometry.getEnvelopeInternal();
        double width = env.getWidth();
        double size = width > (height = env.getHeight()) ? width : height;
        double tolerance = size / 1000.0;
        if (geometry instanceof Polygon || geometry instanceof MultiPolygon) {
            MaximumInscribedCircle mic = new MaximumInscribedCircle(geometry, tolerance);
            Geometry geom = geometry.getFactory().createPoint(mic.getCenter().getCoordinate()).buffer(mic.getRadiusLine().getLength());
            geom.setSRID(geometry.getSRID());
            return geom;
        }
        LargestEmptyCircle lec = new LargestEmptyCircle(geometry, null, tolerance);
        Geometry geom = lec.getCenter().buffer(lec.getRadiusLine().getLength());
        geom.setSRID(geometry.getSRID());
        return geom;
    }
}

