/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.crs;

import java.sql.Connection;
import java.sql.SQLException;
import org.h2gis.api.AbstractFunction;
import org.h2gis.api.ScalarFunction;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.dbtypes.DBTypes;

public class UpdateGeometrySRID
extends AbstractFunction
implements ScalarFunction {
    public UpdateGeometrySRID() {
        this.addProperty("remarks", "Updates the SRID of all features in a geometry column. ");
    }

    public String getJavaStaticMethod() {
        return "changeSRID";
    }

    public static boolean changeSRID(Connection connection, String table_name, String column_name, int srid) throws SQLException {
        return UpdateGeometrySRID.changeSRID(connection, null, null, table_name, column_name, srid);
    }

    public static boolean changeSRID(Connection connection, String schema_name, String table_name, String column_name, int srid) throws SQLException {
        return UpdateGeometrySRID.changeSRID(connection, null, schema_name, table_name, column_name, srid);
    }

    public static boolean changeSRID(Connection connection, String catalog_name, String schema_name, String table_name, String column_name, int srid) throws SQLException {
        TableLocation tableLocation = new TableLocation(catalog_name, schema_name, table_name, DBTypes.H2GIS);
        return GeometryTableUtilities.alterSRID((Connection)connection, (TableLocation)tableLocation, (String)column_name, (int)srid);
    }
}

