/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.distance;

import java.sql.SQLException;
import java.util.HashSet;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class ST_ClosestCoordinate
extends DeterministicScalarFunction {
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();

    public ST_ClosestCoordinate() {
        this.addProperty("remarks", "Computes the closest coordinate(s) contained in the given geometry starting from the given point, using the 2D distance.");
    }

    public String getJavaStaticMethod() {
        return "getFurthestCoordinate";
    }

    public static Geometry getFurthestCoordinate(Point point, Geometry geom) throws SQLException {
        if (point == null || geom == null) {
            return null;
        }
        if (point.isEmpty() || geom.isEmpty()) {
            return null;
        }
        if (point.getSRID() != geom.getSRID()) {
            throw new SQLException("Operation on mixed SRID geometries not supported");
        }
        double minDistance = Double.POSITIVE_INFINITY;
        Coordinate pointCoordinate = point.getCoordinate();
        HashSet<Point> closestCoordinates = new HashSet<Point>();
        for (Coordinate c : geom.getCoordinates()) {
            double distance = c.distance(pointCoordinate);
            if (Double.compare(distance, minDistance) == 0) {
                closestCoordinates.add(GEOMETRY_FACTORY.createPoint(c));
            }
            if (Double.compare(distance, minDistance) >= 0) continue;
            minDistance = distance;
            closestCoordinates.clear();
            closestCoordinates.add(GEOMETRY_FACTORY.createPoint(c));
        }
        if (closestCoordinates.size() == 1) {
            return (Geometry)closestCoordinates.iterator().next();
        }
        return GEOMETRY_FACTORY.createMultiPoint(closestCoordinates.toArray(new Point[0]));
    }
}

