/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.distance;

import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.operation.distance.DistanceOp;

public class ST_ClosestPoint
extends DeterministicScalarFunction {
    public ST_ClosestPoint() {
        this.addProperty("remarks", "Returns the 2D point on geometry A that is closest to geometry B.");
    }

    public String getJavaStaticMethod() {
        return "closestPoint";
    }

    public static Point closestPoint(Geometry geomA, Geometry geomB) throws SQLException {
        if (geomA == null || geomB == null) {
            return null;
        }
        if (geomA.isEmpty() || geomB.isEmpty()) {
            return null;
        }
        if (geomA.getSRID() != geomB.getSRID()) {
            throw new SQLException("Operation on mixed SRID geometries not supported");
        }
        return geomA.getFactory().createPoint(DistanceOp.nearestPoints((Geometry)geomA, (Geometry)geomB)[0]);
    }
}

