/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.edit;

import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;

public class ST_ZUpdateLineExtremities
extends DeterministicScalarFunction {
    public ST_ZUpdateLineExtremities() {
        this.addProperty("remarks", "Replace the start and end z values of a linestring or multilinestring.\nBy default the other z values are interpolated according the length of the line.\nSet false if you want to update only the start and end z values.");
    }

    public String getJavaStaticMethod() {
        return "updateZExtremities";
    }

    public static Geometry updateZExtremities(Geometry geometry, double startZ, double endZ) {
        return ST_ZUpdateLineExtremities.updateZExtremities(geometry, startZ, endZ, true);
    }

    public static Geometry updateZExtremities(Geometry geometry, double startZ, double endZ, boolean interpolate) {
        if (geometry == null) {
            return null;
        }
        if (geometry instanceof LineString) {
            return ST_ZUpdateLineExtremities.force3DStartEnd((LineString)geometry, startZ, endZ, interpolate);
        }
        if (geometry instanceof MultiLineString) {
            int nbGeom = geometry.getNumGeometries();
            LineString[] lines = new LineString[nbGeom];
            for (int i = 0; i < nbGeom; ++i) {
                LineString subGeom = (LineString)geometry.getGeometryN(i);
                lines[i] = (LineString)ST_ZUpdateLineExtremities.force3DStartEnd(subGeom, startZ, endZ, interpolate);
            }
            return geometry.getFactory().createMultiLineString(lines);
        }
        return null;
    }

    private static Geometry force3DStartEnd(LineString lineString, final double startZ, final double endZ, final boolean interpolate) {
        final double bigD = lineString.getLength();
        final double z = endZ - startZ;
        final Coordinate coordEnd = lineString.getCoordinates()[lineString.getCoordinates().length - 1];
        lineString.apply(new CoordinateSequenceFilter(){
            boolean done = false;

            public boolean isGeometryChanged() {
                return true;
            }

            public boolean isDone() {
                return this.done;
            }

            public void filter(CoordinateSequence seq, int i) {
                double x = seq.getX(i);
                double y = seq.getY(i);
                if (i == 0) {
                    seq.setOrdinate(i, 0, x);
                    seq.setOrdinate(i, 1, y);
                    seq.setOrdinate(i, 2, startZ);
                } else if (i == seq.size() - 1) {
                    seq.setOrdinate(i, 0, x);
                    seq.setOrdinate(i, 1, y);
                    seq.setOrdinate(i, 2, endZ);
                } else if (interpolate) {
                    double smallD = seq.getCoordinate(i).distance(coordEnd);
                    double factor = smallD / bigD;
                    seq.setOrdinate(i, 0, x);
                    seq.setOrdinate(i, 1, y);
                    seq.setOrdinate(i, 2, startZ + factor * z);
                }
                if (i == seq.size()) {
                    this.done = true;
                }
            }
        });
        return lineString;
    }
}

