/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.operators;

import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.operation.overlayng.OverlayNGRobust;

public class ST_Union
extends DeterministicScalarFunction {
    public ST_Union() {
        this.addProperty("remarks", "Compute the union of two or more Geometries.");
    }

    public String getJavaStaticMethod() {
        return "union";
    }

    public static Geometry union(Geometry a, Geometry b) throws SQLException {
        if (a == null || b == null) {
            return null;
        }
        if (a.isEmpty()) {
            return a;
        }
        if (b.isEmpty()) {
            return OverlayNGRobust.union((Geometry)a);
        }
        if (a.getSRID() != b.getSRID()) {
            throw new SQLException("Operation on mixed SRID geometries not supported");
        }
        return OverlayNGRobust.overlay((Geometry)a, (Geometry)b, (int)2);
    }

    public static Geometry union(Geometry geomList) {
        if (geomList == null) {
            return null;
        }
        if (geomList.isEmpty()) {
            return geomList;
        }
        return OverlayNGRobust.union((Geometry)geomList);
    }
}

