/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.predicates;

import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;

public class ST_CoveredBy
extends DeterministicScalarFunction {
    public ST_CoveredBy() {
        this.addProperty("remarks", "Returns true if this geomA is covered by geomB according the definitions : \nEvery point of this geometry is a point of the other geometry.\nThe DE-9IM Intersection Matrix for the two geometries matches\n at least one of the following patterns:\n [T*F**F***]\n [*TF**F***]\n [**FT*F***]\n [**F*TF***]\n");
    }

    public String getJavaStaticMethod() {
        return "execute";
    }

    public static Boolean execute(Geometry geomA, Geometry geomB) throws SQLException {
        if (geomA == null || geomB == null) {
            return null;
        }
        if (geomA.isEmpty() || geomB.isEmpty()) {
            return false;
        }
        if (geomA.getSRID() != geomB.getSRID()) {
            throw new SQLException("Operation on mixed SRID geometries not supported");
        }
        return geomA.coveredBy(geomB);
    }
}

