/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.properties;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.h2.tools.SimpleResultSet;
import org.h2.tools.SimpleRowSource;
import org.h2gis.api.AbstractFunction;
import org.h2gis.api.ScalarFunction;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.TableUtilities;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.h2gis.utilities.dbtypes.DBUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;

public class ST_Explode
extends AbstractFunction
implements ScalarFunction {
    public static final String EXPLODE_FIELD = "EXPLOD_ID";

    public ST_Explode() {
        this.addProperty("remarks", "Explode Geometry Collection into multiple geometries.\nNote : This function supports select query as the first argument.");
    }

    public String getJavaStaticMethod() {
        return "explode";
    }

    public static ResultSet explode(Connection connection, String tableName) throws SQLException {
        String regex = ".*(?i)\\b(select|from)\\b.*";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(tableName);
        if (matcher.find()) {
            if (tableName.startsWith("(") && tableName.endsWith(")")) {
                ExplodeResultSetQuery explodeResultSetQuery = new ExplodeResultSetQuery(connection, tableName, null);
                return explodeResultSetQuery.getResultSet();
            }
            throw new SQLException("The select query must be enclosed in parenthesis: '(SELECT * FROM ORDERS)'.");
        }
        return ST_Explode.explode(connection, tableName, null);
    }

    public static ResultSet explode(Connection connection, String tableName, String fieldName) throws SQLException {
        ExplodeResultSet rowSource = new ExplodeResultSet(connection, TableLocation.parse((String)tableName, (DBTypes)DBUtils.getDBType((Connection)connection)).toString(), fieldName);
        return rowSource.getResultSet();
    }

    public static class ExplodeResultSetQuery
    extends ExplodeResultSet {
        public ExplodeResultSetQuery(Connection connection, String tableName, String spatialFieldName) throws SQLException {
            super(connection, tableName, spatialFieldName);
        }

        @Override
        public void reset() throws SQLException {
            if (this.tableQuery != null && !this.tableQuery.isClosed()) {
                this.close();
            }
            Statement st = this.connection.createStatement();
            this.tableQuery = st.executeQuery(this.tableName);
            this.firstRow = false;
        }

        @Override
        public ResultSet getResultSet() throws SQLException {
            SimpleResultSet rs = new SimpleResultSet((SimpleRowSource)this);
            this.copyfields(rs, this.tableName);
            rs.addColumn(ST_Explode.EXPLODE_FIELD, 4, 10, 0);
            return rs;
        }

        private void copyfields(SimpleResultSet rs, String selectQuery) throws SQLException {
            Statement st = null;
            ResultSet rsQuery = null;
            st = this.connection.createStatement();
            try {
                rsQuery = st.executeQuery(this.limitQuery(selectQuery.toUpperCase()));
                ResultSetMetaData metadata = rsQuery.getMetaData();
                this.columnCount = metadata.getColumnCount();
                for (int i = 1; i <= this.columnCount; ++i) {
                    String type = metadata.getColumnTypeName(i);
                    String columnName = metadata.getColumnName(i);
                    String label = metadata.getColumnLabel(i);
                    if (label != null) {
                        columnName = label;
                    }
                    if (type.toLowerCase().startsWith("geometry") && this.spatialFieldIndex == -1) {
                        this.spatialFieldIndex = i;
                        rs.addColumn(columnName, metadata.getColumnType(i), "GEOMETRY", metadata.getPrecision(i), metadata.getScale(i));
                        continue;
                    }
                    rs.addColumn(columnName, metadata.getColumnType(i), type, metadata.getPrecision(i), metadata.getScale(i));
                }
            }
            catch (SQLException ex) {
                throw new SQLException(ex);
            }
            if (this.spatialFieldIndex == -1) {
                throw new SQLException("The select query " + selectQuery + " does not contain a geometry field");
            }
        }

        private String limitQuery(String selectQuery) {
            selectQuery = ((String)selectQuery).substring(1, ((String)selectQuery).lastIndexOf(")"));
            int findLIMIT = ((String)selectQuery).lastIndexOf("LIMIT ");
            int comma = ((String)selectQuery).lastIndexOf(";");
            selectQuery = findLIMIT == -1 ? (comma == -1 ? (String)selectQuery + " LIMIT 0;" : ((String)selectQuery).substring(0, comma) + " LIMIT 0;") : ((String)selectQuery).substring(0, findLIMIT) + " LIMIT 0;";
            return selectQuery;
        }
    }

    public static class ExplodeResultSet
    implements SimpleRowSource {
        public boolean firstRow = true;
        public ResultSet tableQuery;
        public String tableName;
        public String spatialFieldName;
        public int spatialFieldIndex = -1;
        public int columnCount;
        public Queue<Geometry> sourceRowGeometries = new LinkedList<Geometry>();
        public int explodeId = 1;
        public Connection connection;
        private final TableLocation tableLocation;

        public ExplodeResultSet(Connection connection, String tableName, String spatialFieldName) throws SQLException {
            this.tableName = tableName;
            this.tableLocation = TableLocation.parse((String)tableName, (DBTypes)DBUtils.getDBType((Connection)connection));
            this.spatialFieldName = spatialFieldName;
            this.connection = connection;
        }

        public Object[] readRow() throws SQLException {
            if (this.firstRow) {
                this.reset();
            }
            if (this.sourceRowGeometries.isEmpty()) {
                this.parseRow();
            }
            if (this.sourceRowGeometries.isEmpty()) {
                return null;
            }
            Object[] objects = new Object[this.columnCount + 1];
            for (int i = 1; i <= this.columnCount + 1; ++i) {
                objects[i - 1] = i == this.spatialFieldIndex ? this.sourceRowGeometries.remove() : (i == this.columnCount + 1 ? Integer.valueOf(this.explodeId++) : this.tableQuery.getObject(i));
            }
            return objects;
        }

        private void explode(Geometry geometry) {
            if (geometry instanceof GeometryCollection) {
                int nbOfGeometries = geometry.getNumGeometries();
                for (int i = 0; i < nbOfGeometries; ++i) {
                    this.explode(geometry.getGeometryN(i));
                }
            } else {
                this.sourceRowGeometries.add(geometry);
            }
        }

        public void close() {
            if (this.tableQuery != null) {
                try {
                    this.tableQuery.close();
                    this.tableQuery = null;
                }
                catch (SQLException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }

        private void parseRow() throws SQLException {
            this.sourceRowGeometries.clear();
            this.explodeId = 1;
            if (this.tableQuery.next()) {
                Geometry geometry = (Geometry)this.tableQuery.getObject(this.spatialFieldIndex);
                this.explode(geometry);
                if (this.sourceRowGeometries.isEmpty()) {
                    GeometryFactory factory = geometry.getFactory();
                    if (factory == null) {
                        factory = new GeometryFactory();
                    }
                    if (geometry instanceof MultiLineString) {
                        this.sourceRowGeometries.add((Geometry)factory.createLineString(new Coordinate[0]));
                    } else if (geometry instanceof MultiPolygon) {
                        this.sourceRowGeometries.add((Geometry)factory.createPolygon(null, null));
                    } else {
                        this.sourceRowGeometries.add(null);
                    }
                }
            }
        }

        public void reset() throws SQLException {
            Map.Entry result;
            if (this.tableQuery != null && !this.tableQuery.isClosed()) {
                this.close();
            }
            LinkedHashMap geomNamesAndIndexes = GeometryTableUtilities.getGeometryColumnNamesAndIndexes((Connection)this.connection, (TableLocation)this.tableLocation);
            Map.Entry firstGeomNameAndIndex = geomNamesAndIndexes.entrySet().iterator().next();
            if (this.spatialFieldName != null && !this.spatialFieldName.isEmpty() && (result = (Map.Entry)geomNamesAndIndexes.entrySet().stream().filter(tuple -> this.spatialFieldName.equalsIgnoreCase((String)tuple.getKey())).findAny().orElse(null)) != null) {
                firstGeomNameAndIndex = result;
            }
            this.spatialFieldName = (String)firstGeomNameAndIndex.getKey();
            this.spatialFieldIndex = (Integer)firstGeomNameAndIndex.getValue();
            Statement st = this.connection.createStatement();
            this.tableQuery = st.executeQuery("SELECT * FROM " + this.tableLocation);
            this.firstRow = false;
            ResultSetMetaData meta = this.tableQuery.getMetaData();
            this.columnCount = meta.getColumnCount();
        }

        public ResultSet getResultSet() throws SQLException {
            SimpleResultSet rs = new SimpleResultSet((SimpleRowSource)this);
            TableUtilities.copyFields((Connection)this.connection, (SimpleResultSet)rs, (TableLocation)this.tableLocation);
            rs.addColumn(ST_Explode.EXPLODE_FIELD, 4, 10, 0);
            return rs;
        }
    }
}

