/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.snap;

import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.operation.overlay.snap.GeometrySnapper;

public class ST_SnapToSelf
extends DeterministicScalarFunction {
    public ST_SnapToSelf() {
        this.addProperty("remarks", "Snaps a geometry to itself with a given tolerance.\nAllows optionally cleaning the result to ensure it is topologically valid. true by default");
    }

    public String getJavaStaticMethod() {
        return "execute";
    }

    public static Geometry execute(Geometry geometryA, double distance) throws SQLException {
        return ST_SnapToSelf.execute(geometryA, distance, true);
    }

    public static Geometry execute(Geometry geometryA, double distance, boolean clean) throws SQLException {
        if (geometryA == null) {
            return null;
        }
        return GeometrySnapper.snapToSelf((Geometry)geometryA, (double)distance, (boolean)clean);
    }
}

