/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.split;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.noding.IntersectionAdder;
import org.locationtech.jts.noding.MCIndexNoder;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.SegmentIntersector;
import org.locationtech.jts.noding.SegmentString;

public class ST_LineIntersector
extends DeterministicScalarFunction {
    private static final RobustLineIntersector ROBUST_INTERSECTOR = new RobustLineIntersector();

    public ST_LineIntersector() {
        this.addProperty("remarks", "Split an input geometry by another geometry. \nThis function uses a more robust intersection algorithm than the ST_Split function.\nIt computes the intersections between the line segments of the input geometries.A collection of LineString is returned.\nNote :  This function supports only 2D geometry (XY)");
    }

    public String getJavaStaticMethod() {
        return "lineIntersector";
    }

    public static Geometry lineIntersector(Geometry inputLines, Geometry clipper) throws IllegalArgumentException, SQLException {
        if (inputLines == null || clipper == null) {
            return null;
        }
        if (inputLines.isEmpty() || clipper.isEmpty()) {
            return inputLines;
        }
        if (inputLines.getSRID() != clipper.getSRID()) {
            throw new SQLException("Operation on mixed SRID geometries not supported");
        }
        if (inputLines.getDimension() == 1) {
            MCIndexNoder mCIndexNoder = new MCIndexNoder();
            mCIndexNoder.setSegmentIntersector((SegmentIntersector)new IntersectionAdder((LineIntersector)ROBUST_INTERSECTOR));
            mCIndexNoder.computeNodes(ST_LineIntersector.getSegments(inputLines, clipper));
            Collection nodedSubstring = mCIndexNoder.getNodedSubstrings();
            GeometryFactory gf = inputLines.getFactory();
            ArrayList<LineString> linestrings = new ArrayList<LineString>(nodedSubstring.size());
            for (SegmentString segment : nodedSubstring) {
                if ((Integer)segment.getData() != 0) continue;
                Coordinate[] cc = segment.getCoordinates();
                if ((cc = CoordinateArrays.atLeastNCoordinatesOrNothing((int)2, (Coordinate[])cc)).length <= 1) continue;
                linestrings.add(gf.createLineString(cc));
            }
            if (linestrings.isEmpty()) {
                return inputLines;
            }
            return gf.createMultiLineString(linestrings.toArray(new LineString[0]));
        }
        throw new IllegalArgumentException("Split a " + inputLines.getGeometryType() + " by a " + clipper.getGeometryType() + " is not supported.");
    }

    public static ArrayList<SegmentString> getSegments(Geometry inputLines, Geometry clipper) {
        ArrayList<SegmentString> segments = new ArrayList<SegmentString>();
        ST_LineIntersector.addGeometryToSegments(inputLines, 0, segments);
        ST_LineIntersector.addGeometryToSegments(clipper, 1, segments);
        return segments;
    }

    public static void addGeometryToSegments(Geometry geometry, int flag, ArrayList<SegmentString> segments) {
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            Geometry component = geometry.getGeometryN(i);
            if (component instanceof Polygon) {
                ST_LineIntersector.add((Polygon)component, flag, segments);
                continue;
            }
            if (!(component instanceof LineString)) continue;
            ST_LineIntersector.add((LineString)component, flag, segments);
        }
    }

    private static void add(Polygon poly, int flag, ArrayList<SegmentString> segments) {
        ST_LineIntersector.add((LineString)poly.getExteriorRing(), flag, segments);
        for (int j = 0; j < poly.getNumInteriorRing(); ++j) {
            ST_LineIntersector.add((LineString)poly.getInteriorRingN(j), flag, segments);
        }
    }

    private static void add(LineString line, int flag, ArrayList<SegmentString> segments) {
        NodedSegmentString ss = new NodedSegmentString(line.getCoordinates(), (Object)flag);
        segments.add((SegmentString)ss);
    }
}

