/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.volume;

import java.util.ArrayList;
import org.locationtech.jts.algorithm.CGAlgorithms;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class GeometryExtrude {
    private GeometryExtrude() {
    }

    public static GeometryCollection extrudePolygonAsGeometry(Polygon polygon, double height) {
        GeometryFactory factory = polygon.getFactory();
        Geometry[] geometries = new Geometry[3];
        LineString shell = GeometryExtrude.getClockWise((LineString)polygon.getExteriorRing());
        ArrayList<Polygon> walls = new ArrayList<Polygon>();
        for (int i = 1; i < shell.getNumPoints(); ++i) {
            walls.add(GeometryExtrude.extrudeEdge(shell.getCoordinateN(i - 1), shell.getCoordinateN(i), height, factory));
        }
        int nbOfHoles = polygon.getNumInteriorRing();
        LinearRing[] holes = new LinearRing[nbOfHoles];
        for (int i = 0; i < nbOfHoles; ++i) {
            LineString hole = GeometryExtrude.getCounterClockWise((LineString)polygon.getInteriorRingN(i));
            for (int j = 1; j < hole.getNumPoints(); ++j) {
                walls.add(GeometryExtrude.extrudeEdge(hole.getCoordinateN(j - 1), hole.getCoordinateN(j), height, factory));
            }
            holes[i] = factory.createLinearRing(hole.getCoordinateSequence());
        }
        geometries[0] = factory.createPolygon(factory.createLinearRing(shell.getCoordinateSequence()), holes);
        geometries[1] = factory.createMultiPolygon(walls.toArray(new Polygon[0]));
        geometries[2] = GeometryExtrude.extractRoof(polygon, height);
        return polygon.getFactory().createGeometryCollection(geometries);
    }

    public static GeometryCollection extrudeLineStringAsGeometry(LineString lineString, double height) {
        Geometry[] geometries = new Geometry[3];
        GeometryFactory factory = lineString.getFactory();
        Coordinate[] coords = lineString.getCoordinates();
        Polygon[] walls = new Polygon[coords.length - 1];
        for (int i = 0; i < coords.length - 1; ++i) {
            walls[i] = GeometryExtrude.extrudeEdge(coords[i], coords[i + 1], height, factory);
        }
        lineString.apply((CoordinateSequenceFilter)new UpdateZValue(0.0));
        geometries[0] = lineString;
        geometries[1] = factory.createMultiPolygon(walls);
        geometries[2] = GeometryExtrude.extractRoof(lineString, height);
        return factory.createGeometryCollection(geometries);
    }

    public static Geometry extractRoof(LineString lineString, double height) {
        LineString result = (LineString)lineString.copy();
        result.apply((CoordinateSequenceFilter)new UpdateZValue(height));
        return result;
    }

    public static MultiPolygon extractWalls(Polygon polygon, double height) {
        GeometryFactory factory = polygon.getFactory();
        LineString shell = GeometryExtrude.getClockWise((LineString)polygon.getExteriorRing());
        ArrayList<Polygon> walls = new ArrayList<Polygon>();
        for (int i = 1; i < shell.getNumPoints(); ++i) {
            walls.add(GeometryExtrude.extrudeEdge(shell.getCoordinateN(i - 1), shell.getCoordinateN(i), height, factory));
        }
        int nbOfHoles = polygon.getNumInteriorRing();
        for (int i = 0; i < nbOfHoles; ++i) {
            LineString hole = GeometryExtrude.getCounterClockWise((LineString)polygon.getInteriorRingN(i));
            for (int j = 1; j < hole.getNumPoints(); ++j) {
                walls.add(GeometryExtrude.extrudeEdge(hole.getCoordinateN(j - 1), hole.getCoordinateN(j), height, factory));
            }
        }
        return polygon.getFactory().createMultiPolygon(walls.toArray(new Polygon[0]));
    }

    public static Polygon extractRoof(Polygon polygon, double height) {
        GeometryFactory factory = polygon.getFactory();
        Polygon roofP = (Polygon)polygon.copy();
        roofP.apply((CoordinateSequenceFilter)new UpdateZValue(height));
        LinearRing shell = factory.createLinearRing(GeometryExtrude.getCounterClockWise((LineString)roofP.getExteriorRing()).getCoordinates());
        int nbOfHoles = roofP.getNumInteriorRing();
        LinearRing[] holes = new LinearRing[nbOfHoles];
        for (int i = 0; i < nbOfHoles; ++i) {
            holes[i] = factory.createLinearRing(GeometryExtrude.getClockWise((LineString)roofP.getInteriorRingN(i)).getCoordinates());
        }
        return factory.createPolygon(shell, holes);
    }

    public static MultiPolygon extractWalls(LineString lineString, double height) {
        GeometryFactory factory = lineString.getFactory();
        Coordinate[] coords = lineString.getCoordinates();
        Polygon[] walls = new Polygon[coords.length - 1];
        for (int i = 0; i < coords.length - 1; ++i) {
            walls[i] = GeometryExtrude.extrudeEdge(coords[i], coords[i + 1], height, factory);
        }
        return lineString.getFactory().createMultiPolygon(walls);
    }

    private static LineString getClockWise(LineString lineString) {
        Coordinate c0 = lineString.getCoordinateN(0);
        Coordinate c1 = lineString.getCoordinateN(1);
        Coordinate c2 = lineString.getCoordinateN(2);
        lineString.apply((CoordinateSequenceFilter)new UpdateZValue(0.0));
        if (CGAlgorithms.computeOrientation((Coordinate)c0, (Coordinate)c1, (Coordinate)c2) == -1) {
            return lineString;
        }
        return lineString.reverse();
    }

    private static LineString getCounterClockWise(LineString lineString) {
        Coordinate c0 = lineString.getCoordinateN(0);
        Coordinate c1 = lineString.getCoordinateN(1);
        Coordinate c2 = lineString.getCoordinateN(2);
        lineString.apply((CoordinateSequenceFilter)new UpdateZValue(0.0));
        if (CGAlgorithms.computeOrientation((Coordinate)c0, (Coordinate)c1, (Coordinate)c2) == 1) {
            return lineString;
        }
        return lineString.reverse();
    }

    private static Polygon extractFloor(Polygon polygon) {
        GeometryFactory factory = polygon.getFactory();
        LinearRing shell = factory.createLinearRing(GeometryExtrude.getClockWise((LineString)polygon.getExteriorRing()).getCoordinates());
        int nbOfHoles = polygon.getNumInteriorRing();
        LinearRing[] holes = new LinearRing[nbOfHoles];
        for (int i = 0; i < nbOfHoles; ++i) {
            holes[i] = factory.createLinearRing(GeometryExtrude.getCounterClockWise((LineString)polygon.getInteriorRingN(i)).getCoordinates());
        }
        return factory.createPolygon(shell, holes);
    }

    private static Polygon extrudeEdge(Coordinate beginPoint, Coordinate endPoint, double height, GeometryFactory factory) {
        beginPoint.z = Double.isNaN(beginPoint.z) ? 0.0 : beginPoint.z;
        endPoint.z = Double.isNaN(endPoint.z) ? 0.0 : endPoint.z;
        return factory.createPolygon(new Coordinate[]{beginPoint, new Coordinate(beginPoint.x, beginPoint.y, beginPoint.z + height), new Coordinate(endPoint.x, endPoint.y, endPoint.z + height), endPoint, beginPoint});
    }

    public static class UpdateZValue
    implements CoordinateSequenceFilter {
        private boolean done = false;
        private final double z;

        public UpdateZValue(double z) {
            this.z = z;
        }

        public boolean isGeometryChanged() {
            return true;
        }

        public boolean isDone() {
            return this.done;
        }

        public void filter(CoordinateSequence seq, int i) {
            Coordinate coord = seq.getCoordinate(i);
            double currentZ = coord.z;
            if (!Double.isNaN(currentZ)) {
                seq.setOrdinate(i, 2, currentZ + this.z);
            } else {
                seq.setOrdinate(i, 2, this.z);
            }
            if (i == seq.size()) {
                this.done = true;
            }
        }
    }
}

