/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.network.graph_creator;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;

public class GraphFunctionParser {
    private String weightColumn;
    private Orientation globalOrientation;
    private String edgeOrientation;
    public static final String SEPARATOR = "-";
    public static final String DIRECTED = "directed";
    public static final String REVERSED = "reversed";
    public static final String UNDIRECTED = "undirected";
    public static final String EDGE_ORIENTATION_COLUMN = "edge_orientation_column";
    public static final String POSSIBLE_ORIENTATIONS = "'directed - edge_orientation_column' | 'reversed - edge_orientation_column' | 'undirected'";
    public static final String ORIENTATION_ERROR = "Bad orientation format. Enter 'directed - edge_orientation_column' | 'reversed - edge_orientation_column' | 'undirected'.";

    protected String parseWeight(String v) {
        if (v == null) {
            return null;
        }
        return v.trim();
    }

    protected static Orientation parseGlobalOrientation(String v) {
        if (v == null) {
            return null;
        }
        if (GraphFunctionParser.isDirectedString(v)) {
            return Orientation.DIRECTED;
        }
        if (GraphFunctionParser.isReversedString(v)) {
            return Orientation.REVERSED;
        }
        if (GraphFunctionParser.isUndirectedString(v)) {
            return Orientation.UNDIRECTED;
        }
        throw new IllegalArgumentException(ORIENTATION_ERROR);
    }

    private static boolean isDirectedString(String s) {
        if (s == null) {
            return false;
        }
        return s.toLowerCase().contains(DIRECTED) && !GraphFunctionParser.isUndirectedString(s);
    }

    private static boolean isReversedString(String s) {
        if (s == null) {
            return false;
        }
        return s.toLowerCase().contains(REVERSED);
    }

    private static boolean isUndirectedString(String s) {
        if (s == null) {
            return false;
        }
        return s.toLowerCase().contains(UNDIRECTED);
    }

    private boolean isOrientationString(String s) {
        return GraphFunctionParser.isDirectedString(s) || GraphFunctionParser.isReversedString(s) || GraphFunctionParser.isUndirectedString(s);
    }

    private boolean isWeightString(String s) {
        if (s == null) {
            return false;
        }
        return !this.isOrientationString(s);
    }

    protected String parseEdgeOrientation(String v) {
        if (v == null) {
            return null;
        }
        if (!v.contains(SEPARATOR)) {
            throw new IllegalArgumentException(ORIENTATION_ERROR);
        }
        String[] s = v.split(SEPARATOR);
        if (s.length == 2) {
            return s[1].trim();
        }
        throw new IllegalArgumentException(ORIENTATION_ERROR);
    }

    public void parseWeightAndOrientation(String arg1, String arg2) {
        if (arg1 == null && arg2 == null || this.isWeightString(arg1) && arg2 == null || arg1 == null && this.isWeightString(arg2)) {
            throw new IllegalArgumentException("You must specify the orientation.");
        }
        if (this.isWeightString(arg1) && this.isWeightString(arg2)) {
            throw new IllegalArgumentException("Cannot specify the weight column twice.");
        }
        if (this.isOrientationString(arg1) && this.isOrientationString(arg2)) {
            throw new IllegalArgumentException("Cannot specify the orientation twice.");
        }
        if (this.isWeightString(arg1) || this.isOrientationString(arg2)) {
            this.setWeightAndOrientation(arg1, arg2);
        }
        if (this.isOrientationString(arg1) || this.isWeightString(arg2)) {
            this.setWeightAndOrientation(arg2, arg1);
        }
    }

    private void setWeightAndOrientation(String weight, String orient) {
        this.weightColumn = this.parseWeight(weight);
        this.globalOrientation = GraphFunctionParser.parseGlobalOrientation(orient);
        if (this.globalOrientation != null && !this.globalOrientation.equals((Object)Orientation.UNDIRECTED)) {
            this.edgeOrientation = this.parseEdgeOrientation(orient);
        }
    }

    public String getWeightColumn() {
        return this.weightColumn;
    }

    public Orientation getGlobalOrientation() {
        return this.globalOrientation;
    }

    public String getEdgeOrientation() {
        return this.edgeOrientation;
    }

    protected static boolean isDestinationsString(String s) {
        return s.substring(0, 1).matches("[0-9]");
    }

    public static int[] parseDestinationsString(String s) {
        if (!s.contains(",")) {
            return new int[]{Integer.valueOf(s.trim())};
        }
        String[] array = s.split(",");
        int[] destinations = new int[array.length];
        for (int i = 0; i < destinations.length; ++i) {
            String stringWithNoWhiteSpaces = array[i].replaceAll("\\s", "");
            if (stringWithNoWhiteSpaces.isEmpty()) {
                throw new IllegalArgumentException("Empty destination. Too many commas?");
            }
            destinations[i] = Integer.valueOf(stringWithNoWhiteSpaces);
        }
        return destinations;
    }

    public static TableLocation parseInputTable(Connection connection, String inputTable) throws SQLException {
        return TableLocation.parse((String)inputTable, (Boolean)JDBCUtilities.isH2DataBase((DatabaseMetaData)connection.getMetaData()));
    }

    public static TableLocation suffixTableLocation(TableLocation inputTable, String suffix) {
        return new TableLocation(inputTable.getCatalog(), inputTable.getSchema(), inputTable.getTable() + suffix);
    }

    public static enum Orientation {
        DIRECTED,
        REVERSED,
        UNDIRECTED;

    }
}

